/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import com.mulesoft.dias.ex.AgentConfiguratorException;
import com.mulesoft.dias.util.InstallerMessages;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class MuleHomePath {
    private static String getMuleHome() {
        return System.getProperty("muleHome");
    }

    public static Path getConfigPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "conf", file);
    }

    public static Path getMule3AgentPluginPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "plugins", "mule-agent-plugin", "lib", file);
    }

    public static Path getMule4gentPluginPath() {
        return Paths.get(MuleHomePath.getMuleHome(), "server-plugins", "mule-agent-plugin", "lib");
    }

    public static Path getAMLibPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "am", "lib", file);
    }

    public static Path getMuleLibPath(String file) {
        return MuleHomePath.findPath(MuleHomePath.getMuleHome(), "lib", "mule", file).orElseThrow(() -> new AgentConfiguratorException(InstallerMessages.invalidMuleLibPath()));
    }

    private static Optional<Path> findPath(String first, String ... more) {
        try {
            return Optional.ofNullable(Paths.get(first, more)).filter(path -> path.toFile().exists());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

