/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.domain.monitoring.ApplicationMetrics;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Maps;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;

@Named(value="mule.agent.analytics.appstats")
@Singleton
public class AppStatsHandler
extends AbstractMessageHandler
implements InternalMessageHandler<GroupedApplicationsMetrics> {
    @GuardedBy(value="vizPropsLock")
    final Map<String, Map<String, String>> vizProps = new HashMap<String, Map<String, String>>();
    private final Object vizPropsLock = new Object();

    public boolean handle(GroupedApplicationsMetrics message) {
        if (!this.isEnabled() || message == null) {
            return false;
        }
        for (ApplicationMetrics am : message.getMetricsByApplicationName().values()) {
            String deploymentHash;
            String appName = this.configuration.overrideAppId(am.getApplicationName());
            List<Tuple<String, String>> tags = this.createBaseTags();
            tags.add(Tuple.tuple("app_id", appName));
            tags.add(Tuple.tuple("deployment_type", this.configuration.getDeploymentType().name()));
            String publicIP = this.configuration.getPublicIP();
            if (publicIP != null) {
                tags.add(Tuple.tuple("public_ip", publicIP));
            }
            if ((deploymentHash = this.configuration.getDeploymentHash()) != null) {
                tags.add(Tuple.tuple("deployment_hash", deploymentHash));
            }
            for (Map.Entry<String, String> entry : Maps.emptyIfNull(this.getVizProps(appName)).entrySet()) {
                tags.add(Tuple.tuple(entry.getKey(), entry.getValue()));
            }
            Long timestamp = null;
            ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
            for (Metric metric : am.getMetrics()) {
                String name = metric.getName();
                Number value = metric.getValue();
                values.add(Tuple.tuple(name, value.toString()));
                if (timestamp != null) continue;
                timestamp = metric.getTimestamp();
            }
            if (timestamp == null) continue;
            MetricRecord record = MetricRecord.create("app_stats", tags, values, timestamp);
            if (this.output == null || record == null) continue;
            this.output.write(record.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterApp(String appName) {
        Object object = this.vizPropsLock;
        synchronized (object) {
            this.vizProps.remove(appName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getVizProps(String appName) {
        if (!this.configuration.isAppDeployed(appName)) {
            return Collections.emptyMap();
        }
        Object object = this.vizPropsLock;
        synchronized (object) {
            Map<String, String> result = this.vizProps.get(appName);
            if (result == null) {
                result = this.configuration.getVisualizerProperties(appName);
                this.vizProps.put(appName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Map<String, String>> getCachedVizProps() {
        Object object = this.vizPropsLock;
        synchronized (object) {
            return this.vizProps;
        }
    }
}

