/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.Registry;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractDeploymentListener;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.application.Application;
import org.mule.registry.MuleRegistryHelper;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    @Inject
    protected List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Inject
    protected AppStatsHandler appStatsHandler;
    private DeploymentService deploymentService;
    private DeploymentListener deploymentListener;
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();
    private final Object notificationListenersLock = new Object();

    public void start() {
        if (this.deploymentService == null) {
            LOGGER.error("DeploymentService not set");
            return;
        }
        this.startCollector(3);
        if (this.deploymentListener == null) {
            this.deploymentListener = new CollectorDeploymentListener();
        }
        this.deploymentService.addDeploymentListener(this.deploymentListener);
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListeners(String appId, MuleContext appMuleContext) {
        if (appMuleContext != null) {
            try {
                LOGGER.info("Registering listeners for application {}", (Object)appId);
                appId = this.configuration.overrideAppId(appId);
                Object object = this.notificationListenersLock;
                synchronized (object) {
                    if (!this.connectorListeners.containsKey(appId)) {
                        ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, appId);
                        this.connectorListeners.put(appId, connectorListener);
                        appMuleContext.registerListener((ServerNotificationListener)connectorListener);
                    }
                    if (!this.processorListeners.containsKey(appId)) {
                        ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, this.configuration, appId);
                        this.processorListeners.put(appId, processorListener);
                        appMuleContext.registerListener((ServerNotificationListener)processorListener);
                    }
                    if (!this.customListeners.containsKey(appId)) {
                        CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, appId);
                        this.customListeners.put(appId, customListener);
                        appMuleContext.registerListener((ServerNotificationListener)customListener);
                    }
                }
            }
            catch (NotificationException e) {
                LOGGER.error("Could not register listeners for application " + appId, (Throwable)e);
            }
        }
    }

    private void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                this.registerListeners(app.getArtifactName(), app.getMuleContext());
                this.loadAppSpecificProperties(app.getArtifactName(), app.getMuleContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListenersForAllApps() {
        LOGGER.info("Stopping");
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                String appName = app.getArtifactName();
                MuleContext appMuleContext = app.getMuleContext();
                LOGGER.info("Un-registering listeners for application {}", (Object)appName);
                Object object = this.notificationListenersLock;
                synchronized (object) {
                    CustomNotificationListener customListener;
                    ConnectorNotificationListener connectorListener;
                    ProcessorNotificationListener processorListener = this.processorListeners.remove(appName);
                    if (processorListener != null) {
                        appMuleContext.unregisterListener((ServerNotificationListener)processorListener);
                    }
                    if ((connectorListener = this.connectorListeners.remove(appName)) != null) {
                        appMuleContext.unregisterListener((ServerNotificationListener)connectorListener);
                    }
                    if ((customListener = this.customListeners.remove(appName)) != null) {
                        appMuleContext.unregisterListener((ServerNotificationListener)customListener);
                    }
                }
            }
            if (this.deploymentListener != null) {
                this.deploymentService.removeDeploymentListener(this.deploymentListener);
                this.deploymentListener = null;
            }
        }
    }

    private void loadAppSpecificProperties(String appId, MuleContext appMuleContext) {
        if (appMuleContext != null) {
            String overrideAppId = this.configuration.overrideAppId(appId);
            if (this.agentApplicationPropertiesService != null) {
                this.configuration.addAppSpecificProperties(overrideAppId, this.agentApplicationPropertiesService.getPropertiesForApplication(overrideAppId));
            }
            Properties props = new Properties();
            for (Map.Entry<String, String> entry : CollectorAgentService.lookupStringProperties(appMuleContext).entrySet()) {
                if (!entry.getKey().startsWith("anypoint.platform.visualizer.")) continue;
                props.setProperty(entry.getKey(), entry.getValue());
            }
            this.configuration.addAppSpecificProperties(overrideAppId, props);
        }
    }

    static Map<String, String> lookupStringProperties(MuleContext appMuleContext) {
        try {
            return appMuleContext.getRegistry().lookupByType(String.class);
        }
        catch (Exception e) {
            return CollectorAgentService.lookupStringPropertiesBestEffort(appMuleContext);
        }
    }

    static Map<String, String> lookupStringPropertiesBestEffort(MuleContext appMuleContext) {
        HashMap<String, String> results = new HashMap<String, String>();
        MuleRegistry muleRegistry = appMuleContext.getRegistry();
        if (muleRegistry instanceof MuleRegistryHelper) {
            for (Registry registry : ((MuleRegistryHelper)muleRegistry).getRegistries()) {
                try {
                    results.putAll(registry.lookupByType(String.class));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to lookup properties from mule registry " + registry, (Throwable)e);
                }
            }
        }
        return results;
    }

    private class CollectorDeploymentListener
    extends AbstractDeploymentListener {
        private CollectorDeploymentListener() {
        }

        public void onMuleContextConfigured(String appName, MuleContext context) {
            CollectorAgentService.this.filebeatConfig.generateAppLogConfigFile(appName);
        }

        public void onDeploymentSuccess(String appName) {
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.configuration.isEnabled()) {
                CollectorAgentService.this.configuration.setAppDeployed(appName);
                CollectorAgentService.this.filebeatConfig.checkAppLogConfigFile(appName);
                if (CollectorAgentService.this.deploymentService != null) {
                    Application app = CollectorAgentService.this.deploymentService.findApplication(appName);
                    if (app != null) {
                        MuleContext context = app.getMuleContext();
                        CollectorAgentService.this.registerListeners(appName, context);
                        CollectorAgentService.this.loadAppSpecificProperties(appName, context);
                    } else {
                        CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                    }
                }
            }
        }

        public void onUndeploymentStart(String appName) {
            CollectorAgentService.this.pipelineRegistry.unregister(appName);
            CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
            CollectorAgentService.this.customMetricHandler.unregister(appName);
            CollectorAgentService.this.filebeatConfig.deleteAppLogConfigFile(appName);
            CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
            CollectorAgentService.this.configuration.setAppUndeployed(appName);
        }
    }
}

