/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.util.MultiMap;

public class ConnectorNotificationListener
extends AbstractListener
implements ConnectorMessageNotificationListener<ConnectorMessageNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorNotificationListener.class);
    private static final Pattern REMOTE_ADDRESS_PATTERN = Pattern.compile("([^/]*)/(.*):(.*)");
    private static final String HOST_HEADER = "host";
    private final EventPipeline<ConnectorMessageNotification> metricPipeline;

    public ConnectorNotificationListener(PipelineRegistry pipelineRegistry, LogWriter logWriter, String appId) {
        this.metricPipeline = pipelineRegistry.createPipeline(appId, Metrics.INBOUND_INVOCATION, new ConnectorMessageNotificationTransformer());
    }

    public void onNotification(ConnectorMessageNotification notification) {
        this.metricPipeline.submit(new Event<ConnectorMessageNotification>(notification));
    }

    private class ConnectorMessageNotificationTransformer
    implements EventMapper<ConnectorMessageNotification, InvocationContext> {
        private ConnectorMessageNotificationTransformer() {
        }

        @Override
        public Collection<Event<InvocationContext>> process(Event<ConnectorMessageNotification> event) {
            InvocationContext.Action action;
            ConnectorMessageNotification notification = event.getValue();
            if (notification.getAction() == null) {
                return Collections.emptyList();
            }
            switch (notification.getAction().getActionId()) {
                case 801: {
                    action = InvocationContext.Action.PRE_INVOKE;
                    break;
                }
                case 805: {
                    action = InvocationContext.Action.POST_INVOKE_SUCCESS;
                    break;
                }
                case 806: {
                    action = InvocationContext.Action.POST_INVOKE_ERROR;
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            Component component = notification.getComponent();
            if (component == null || notification.getEvent() == null || notification.getEvent().getMessage() == null || notification.getEvent().getContext() == null || notification.getEvent().getContext().getId() == null) {
                return Collections.emptyList();
            }
            String componentId = AbstractListener.getComponentName(component);
            NodeType type = NodeType.getTypeFromProcessor(componentId);
            if (NodeType.OTHER == type) {
                return Collections.emptyList();
            }
            InvocationContext context = new InvocationContext();
            context.setConnector(type.getProcessorName());
            context.setAction(action);
            context.setInvocationId(this.processInvocationId(notification.getEvent().getContext().getId()));
            context.setFlowName(notification.getResourceIdentifier());
            if (NodeType.HTTP == type) {
                if (action == InvocationContext.Action.PRE_INVOKE) {
                    try {
                        this.populateHttpAttributes(notification, context);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception while extracting inbound data", (Throwable)e);
                        return Collections.emptyList();
                    }
                } else {
                    Object val;
                    Optional auth = notification.getEvent().getAuthentication();
                    if (auth.isPresent() && ((Authentication)auth.get()).getProperties() != null && (val = ((Authentication)auth.get()).getProperties().get("clientId")) instanceof String) {
                        context.setClientId((String)val);
                    }
                }
            } else {
                context.setRemoteHost(type.getHostNameFromType(componentId));
                context.setOperation(AbstractListener.getComponentOperation(component));
            }
            return Collections.singleton(new Event<long>(notification.getTimestamp(), context));
        }

        private String processInvocationId(String id) {
            if (id != null && id.length() > 36) {
                return id.substring(0, 36);
            }
            return id;
        }

        private void populateHttpAttributes(ConnectorMessageNotification notification, InvocationContext context) throws Exception {
            Object requestPath;
            Object httpRequestAttributes = notification.getEvent().getMessage().getAttributes().getValue();
            MultiMap headers = AbstractListener.invokeViaReflection(httpRequestAttributes, "getHeaders", MultiMap.class);
            if (headers != null) {
                if (headers.containsKey((Object)"x-anypnt-app-worker")) {
                    context.setSourceHash((String)headers.get((Object)"x-anypnt-app-worker"));
                }
                if (headers.containsKey((Object)ConnectorNotificationListener.HOST_HEADER)) {
                    context.setHostHeader((String)headers.get((Object)ConnectorNotificationListener.HOST_HEADER));
                }
                if (headers.containsKey((Object)"x-forwarded-for")) {
                    context.setRemoteHost((String)headers.get((Object)"x-forwarded-for"));
                    String protocol = (String)headers.get((Object)"x-forwarded-proto");
                    if (protocol != null) {
                        context.setProtocol(protocol.toLowerCase());
                    }
                } else {
                    Matcher ipMatcher;
                    Object remoteAddress;
                    Object scheme = AbstractListener.invokeViaReflection(httpRequestAttributes, "getScheme", Object.class);
                    if (scheme != null) {
                        context.setProtocol(scheme.toString().toLowerCase());
                    }
                    if ((remoteAddress = AbstractListener.invokeViaReflection(httpRequestAttributes, "getRemoteAddress", Object.class)) != null && (ipMatcher = REMOTE_ADDRESS_PATTERN.matcher(remoteAddress.toString())).find()) {
                        context.setRemoteHost(ipMatcher.group(2));
                    }
                }
            }
            if ((requestPath = AbstractListener.invokeViaReflection(httpRequestAttributes, "getRequestPath", Object.class)) != null) {
                context.setEndpoint(requestPath.toString());
            }
        }
    }
}

