/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;

public class FactLogger
implements EventConsumer<Fact> {
    private LogWriter output;

    public FactLogger(LogWriter output) {
        this.output = output;
    }

    @Override
    public void consume(Event<Fact> event) {
        MetricRecord record = this.convert(event);
        this.output.write(record.toString());
    }

    private MetricRecord convert(Event<Fact> event) {
        Tuple<String, String> tag;
        Fact fact = event.getValue();
        ArrayList<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
        for (String dimension : fact.getDimensions()) {
            Tuple<String, String> tag2 = Tuple.tuple(dimension, fact.getDimension(dimension));
            tags.add(tag2);
        }
        ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
        for (String metric : fact.getLongMetrics()) {
            tag = Tuple.tuple(metric, Long.toString(fact.getLongMetric(metric)));
            values.add(tag);
        }
        for (String metric : fact.getDoubleMetrics()) {
            tag = Tuple.tuple(metric, Double.toString(fact.getDoubleMetric(metric)));
            values.add(tag);
        }
        return MetricRecord.create(fact.getName(), tags, values, event.getTime());
    }
}

