/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.log;

import com.mulesoft.analytics.collector.util.Strings;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.List;

public class MetricRecord {
    private long time = -1L;
    private String name;
    private List<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
    private List<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
    private static final String SEPARATOR = ",";
    private static final String EQ = "=";

    MetricRecord(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder line = new StringBuilder();
        line.append(this.name);
        if (!this.tags.isEmpty()) {
            line.append(SEPARATOR);
            this.dumpList(line, this.tags);
        }
        if (!this.values.isEmpty()) {
            line.append(" ");
            this.dumpList(line, this.values);
        }
        line.append(" ").append(this.time >= 0L ? this.time : System.currentTimeMillis());
        return line.toString();
    }

    private void dumpList(StringBuilder line, List<Tuple<String, String>> list) {
        for (int i = 0; i < list.size(); ++i) {
            Tuple<String, String> tuple = list.get(i);
            if (tuple.first() == null || tuple.second() == null) continue;
            line.append(Strings.normalize(tuple.first())).append(EQ).append(Strings.normalize(tuple.second()));
            if (i >= list.size() - 1) continue;
            line.append(SEPARATOR);
        }
    }

    public static MetricRecord create(String name, List<Tuple<String, String>> tags, List<Tuple<String, String>> values) {
        MetricRecord metricRecord = new MetricRecord(name);
        metricRecord.tags.addAll(tags);
        metricRecord.values.addAll(values);
        return metricRecord;
    }

    public static MetricRecord create(String name, List<Tuple<String, String>> tags, List<Tuple<String, String>> values, long time) {
        MetricRecord metricRecord = MetricRecord.create(name, tags, values);
        metricRecord.time = time;
        return metricRecord;
    }
}

