/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.configurator;

import com.mulesoft.dias.configurator.AgentConfigurator;
import com.mulesoft.dias.ex.AgentConfiguratorException;
import com.mulesoft.dias.mule.agent.unified.AgentInstaller;
import com.mulesoft.dias.mule.agent.version.MuleVersion;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.ExceptionUtils;
import com.mulesoft.dias.util.InstallerMessages;
import java.io.File;

public class AgentConfiguratorApp {
    public static void main(String[] args) {
        InstallerMessages.loadMessages();
        if (args.length > 0) {
            File file = new File(args[0]);
            if (file.isDirectory()) {
                System.getProperties().setProperty("muleHome", args[0]);
                try {
                    MuleVersion.detect();
                    AgentInstaller agentInstaller = new AgentInstaller();
                    agentInstaller.copyAgentJar();
                    agentInstaller.writeServerId();
                    AgentConfigurator agentConfigurator = new AgentConfigurator();
                    agentConfigurator.pushConfiguration();
                }
                catch (AgentConfiguratorException e) {
                    ConsoleLogger.error(e.getMessage());
                }
                catch (Exception e) {
                    ConsoleLogger.error(InstallerMessages.unexpectedError() + "\n\tException: " + ExceptionUtils.restrictStackTrace(e));
                }
            } else {
                ConsoleLogger.error(InstallerMessages.noMuleHomeProvidedMessage());
            }
        } else {
            ConsoleLogger.error(InstallerMessages.notProvidedMuleHome());
        }
    }
}

