/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent.version;

import com.mulesoft.dias.util.MuleHomePath;
import com.mulesoft.dias.util.Version;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;

public enum MuleAgentVersion {
    MULE_3(MuleHomePath.getMule3AgentPluginPath(""), MuleHomePath.getMule3AgentPluginPath("modules"), "analytics-metrics-collector-mule3-(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)(?:-SNAPSHOT)?.jar"){

        @Override
        public boolean supports(Version v) {
            return v.getMayor() == 3;
        }
    }
    ,
    MULE_4(MuleHomePath.getMule4gentPluginPath(), MuleHomePath.getMule4gentPluginPath(), "analytics-metrics-collector-mule4-(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)(?:-SNAPSHOT)?.jar"){

        @Override
        public boolean supports(Version v) {
            return v.getMayor() == 4;
        }
    };

    private final Path agentPluginPath;
    private final Path unifiedAgentPath;
    private final String unifiedAgentNamePattern;

    private MuleAgentVersion(Path agentPluginPath, Path unifiedAgentPath, String unifiedAgentNamePattern) {
        this.agentPluginPath = agentPluginPath;
        this.unifiedAgentPath = unifiedAgentPath;
        this.unifiedAgentNamePattern = unifiedAgentNamePattern;
    }

    abstract boolean supports(Version var1);

    public String getUnifiedAgentNamePattern() {
        return this.unifiedAgentNamePattern;
    }

    public Path getAgentPluginPath() {
        return this.agentPluginPath;
    }

    public Path getUnifiedAgentPath() {
        return this.unifiedAgentPath;
    }

    public File getAgentAMFile() {
        File libDirectory = MuleHomePath.getAMLibPath("").toFile();
        File[] files = libDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(MuleAgentVersion.this.getUnifiedAgentNamePattern());
            }
        });
        if (files != null && files.length > 0) {
            return files[0];
        }
        throw new IllegalArgumentException("Agent file not found");
    }

    public Path getLibTarget() {
        return Paths.get(this.getUnifiedAgentPath().toString(), this.getAgentAMFile().getName());
    }

    public static MuleAgentVersion detect(Version versionStr) {
        for (MuleAgentVersion muleAgentVersion : MuleAgentVersion.values()) {
            if (!muleAgentVersion.supports(versionStr)) continue;
            return muleAgentVersion;
        }
        throw new IllegalArgumentException(String.format("No am agent support for Mule version '%s'", versionStr));
    }
}

