/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;

public class KeyManager {
    private KeyStore keyStore;
    private KeyManagerFactory keyManagerFactory;

    public KeyManager(String instance) throws KeyStoreException, NoSuchAlgorithmException {
        this.keyStore = KeyStore.getInstance(instance);
        this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void init(String path, String keyStorePassword) throws IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        char[] password = keyStorePassword.toCharArray();
        this.keyStore.load(new FileInputStream(new File(path)), password);
        this.keyManagerFactory.init(this.keyStore, password);
    }

    public javax.net.ssl.KeyManager[] getKeyManagers() {
        return this.keyManagerFactory.getKeyManagers();
    }
}

