﻿#!/usr/bin/pwsh

$SERVICE_NAME="am-filebeat"
$SERVICE_DESCRIPTION="Anypoint Monitoring Filebeat Service"

# Start and enable the service on boot
function filebeat_start {
  Write-Host Starting and enabling $SERVICE_DESCRIPTION
  Set-Service -Name $SERVICE_NAME -StartupType Automatic
  Start-Service -Name $SERVICE_NAME
}

# Stop and disable the service on boot
function filebeat_stop {
  Write-Host Stopping and disabling $SERVICE_DESCRIPTION
  Stop-Service -Name $SERVICE_NAME
  Set-Service -Name $SERVICE_NAME -StartupType Disabled
}

# Restart function - Stops and starts the service
function filebeat_restart {
  Write-Host Restarting $SERVICE_DESCRIPTION
  Restart-Service -Name $SERVICE_NAME
}

# Get user input for the action to perform, call the necessary function
$action = $args[0]

switch($action) {
  'start'   { filebeat_start }
  'stop'    { filebeat_stop }
  'restart' { filebeat_restart }
  default   { Write-Host "Usage: .\$($MyInvocation.MyCommand) {start|stop|restart}" }
}
