/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.services.OnOffSwitch;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public abstract class AbstractMessageHandler
implements Switcher {
    @Configurable(value="true")
    protected boolean enabled;
    private OnOffSwitch enabledSwitch;
    @Inject
    protected Configuration configuration;
    @Inject
    protected MetricLogWriter output;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    @PostConfigure
    public void postConfigurable() {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled() && this.configuration.isRunning();
    }

    List<Tuple<String, String>> createBaseTags() {
        ArrayList<Tuple<String, String>> tags = new ArrayList<Tuple<String, String>>();
        tags.add(Tuple.tuple("org_id", this.configuration.getOrgId()));
        tags.add(Tuple.tuple("env_id", this.configuration.getEnvId()));
        tags.add(Tuple.tuple("cluster_id", this.configuration.getClusterId()));
        tags.add(Tuple.tuple("worker_id", this.configuration.getRuntimeId()));
        String serverId = this.configuration.getServerId();
        if (serverId != null) {
            tags.add(Tuple.tuple("server_id", serverId));
        }
        return tags;
    }
}

