/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.mule.agent.unified;

import com.mulesoft.dias.ex.AgentConfiguratorException;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.mule.agent.version.MuleAgentVersion;
import com.mulesoft.dias.mule.agent.version.MuleVersion;
import com.mulesoft.dias.util.FileUtils;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class AgentInstaller {
    private static final String SERVER_ID_FILE = "server.id";

    public void copyAgentJar() throws IOException {
        MuleAgentVersion muleVersion = MuleVersion.version();
        File muleDirectory = muleVersion.getUnifiedAgentPath().toFile();
        if (!muleDirectory.exists()) {
            FileUtils.createDir(muleDirectory);
        }
        this.deleteOldVersions(muleDirectory);
        this.copyCurrentVersion(muleVersion);
    }

    public void writeServerId() throws IOException {
        Path serverIdPath = MuleHomePath.getAMConfigPath(SERVER_ID_FILE);
        if (!Files.exists(serverIdPath, new LinkOption[0])) {
            String serverIdFromCert = this.getServerIdFromCert();
            Files.write(serverIdPath, serverIdFromCert.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        }
    }

    private void copyCurrentVersion(MuleAgentVersion version) throws IOException {
        Files.copy(version.getAgentAMFile().toPath(), version.getLibTarget(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void deleteOldVersions(File muleDirectory) {
        FileUtils.deleteAgentFiles(muleDirectory, "analytics-metrics-collector-mule.*.jar");
        FileUtils.deleteAgentFiles(muleDirectory, "mule-agent-dias.*.jar");
    }

    private String getServerIdFromCert() throws IOException {
        String agentConfig = new String(Files.readAllBytes(MuleHomePath.getConfigPath("mule-agent.yml")));
        MuleAgentConfig muleAgent = new MuleAgentConfig(agentConfig);
        String keyStorePassword = muleAgent.getKeyStorePassword();
        if (keyStorePassword != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(MuleHomePath.getConfigPath("mule-agent.jks").toFile()), keyStorePassword.toCharArray());
                Enumeration<String> es = keyStore.aliases();
                while (es.hasMoreElements()) {
                    Certificate certificate;
                    String alias = es.nextElement();
                    if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                    String dn = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                    LdapName ldapDn = new LdapName(dn);
                    for (Rdn rdn : ldapDn.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                        return rdn.getValue().toString();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new AgentConfiguratorException("Could not get server id from certificate");
    }
}

