/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.util.ConsoleLogger;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public final class DefaultAuthenticationProxyClient
implements AuthenticationProxyClient {
    private final URI baseUrl;
    private final AsyncHttpClient client;
    private final ObjectMapper objectMapper;

    DefaultAuthenticationProxyClient(URI baseUrl, AsyncHttpClient client, ObjectMapper objectMapper) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> Response post(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePost(this.baseUrl.resolve(path).toString()).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a post request to the auth proxy.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a post request to the auth proxy.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response post(String path) {
        return this.post(path, new Object(), new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public <T> Response post(String path, ProxyServer proxyServer) {
        try {
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePost(this.baseUrl.resolve(path).toString()).setHeaders(new HashMap(0))).setHeader((CharSequence)"Content-Type", "application/json")).setProxyServer(proxyServer)).execute().get();
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a post request to the auth proxy.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a post request to the auth proxy.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response put(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePut(this.baseUrl.resolve(path).toString()).setBody(this.objectMapper.writeValueAsString(body))).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
        }
        catch (JsonProcessingException e) {
            ConsoleLogger.warn("There was an error serializing the request body.");
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            ConsoleLogger.warn("There was an error retrieving the response from a put request to the auth proxy.");
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            ConsoleLogger.warn("There was an error executing a put request to the auth proxy.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response put(String path, T body) {
        return this.put(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            ConsoleLogger.warn("The connection could not be closed.");
            throw new RuntimeException(e);
        }
    }
}

