/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.context.notification.ConnectorMessageNotificationListener;
import org.mule.api.source.MessageSource;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.modules.oauth2.provider.token.AccessTokenStoreHolder;

public class ConnectorNotificationListener
extends AbstractListener
implements ConnectorMessageNotificationListener<ConnectorMessageNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorNotificationListener.class);
    private static final Set<String> SUPPORTED_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https"));
    private static final Pattern REMOTE_ADDRESS_PATTERN = Pattern.compile("([^/]*)/(.*):(.*)");
    static final String X_FORWARDED_PROTO_HEADER = "x-forwarded-proto";
    static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";
    private static final String HOST_HEADER = "host";
    private static final String REQUEST_PATH = "http.request.path";
    static final String HTTP_STATUS_PROP = "http.status";
    private final EventPipeline<NotificationEnvelope> inboudMetricPipeline;
    private final EventPipeline<NotificationEnvelope> outboudMetricPipeline;

    public ConnectorNotificationListener(PipelineRegistry pipelineRegistry, String appId) {
        this.inboudMetricPipeline = pipelineRegistry.createPipeline(appId, Metrics.INBOUND_INVOCATION, new InboundNotificationTransformer());
        this.outboudMetricPipeline = pipelineRegistry.createPipeline(appId, Metrics.OUTBOUND_INVOCATION, new OutboundNotificationTransformer());
    }

    public void onNotification(ConnectorMessageNotification notification) {
        int action = notification.getAction();
        if (action == 801 || action == 805 || action == 806) {
            NotificationEnvelope envelope = new NotificationEnvelope();
            envelope.notification = notification;
            envelope.invocationId = notification.getSource().getUniqueId();
            this.inboudMetricPipeline.submit(new Event<NotificationEnvelope>(envelope));
        } else if (action == 804) {
            NotificationEnvelope envelope = new NotificationEnvelope();
            envelope.notification = notification;
            envelope.invocationId = ConnectorNotificationListener.generateOutboundInvocationId(notification.getSource().getUniqueId());
            this.outboudMetricPipeline.submit(new Event<NotificationEnvelope>(envelope));
        }
    }

    private class OutboundNotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private OutboundNotificationTransformer() {
        }

        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            ConnectorMessageNotification notification = event.getValue().notification;
            URI uri = this.resolveURI(notification);
            if (uri == null) {
                return Collections.emptyList();
            }
            InvocationContext result = new InvocationContext();
            result.setInvocationId(event.getValue().invocationId);
            result.setProtocol(uri.getScheme().toLowerCase());
            result.setRemoteHost(uri.getHost());
            result.setRemotePort(Integer.toString(uri.getPort()));
            result.setEndpoint(uri.getPath());
            return Collections.singleton(new Event<long>(notification.getTimestamp(), result));
        }

        private URI resolveURI(ConnectorMessageNotification notification) {
            URI endpoint;
            try {
                endpoint = new URI(notification.getEndpoint());
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (endpoint.getScheme() == null) {
                return null;
            }
            if (!SUPPORTED_PROTOCOLS.contains(endpoint.getScheme().toLowerCase())) {
                return null;
            }
            return endpoint;
        }
    }

    private class InboundNotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private InboundNotificationTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            ConnectorMessageNotification notification = event.getValue().notification;
            MuleMessage message = notification.getSource();
            try {
                InvocationContext.Action action;
                switch (notification.getAction()) {
                    case 801: {
                        action = InvocationContext.Action.PRE_INVOKE;
                        break;
                    }
                    case 805: {
                        action = this.isHttpFailure(message) ? InvocationContext.Action.POST_INVOKE_ERROR : InvocationContext.Action.POST_INVOKE_SUCCESS;
                        break;
                    }
                    case 806: {
                        action = InvocationContext.Action.POST_INVOKE_ERROR;
                        break;
                    }
                    default: {
                        List<Event<InvocationContext>> list = Collections.emptyList();
                        return list;
                    }
                }
                InvocationContext result = new InvocationContext();
                result.setInvocationId(event.getValue().invocationId);
                FlowConstruct flowConstruct = notification.getFlowConstruct();
                if (flowConstruct instanceof Pipeline) {
                    MessageSource messageSource = ((Pipeline)flowConstruct).getMessageSource();
                    if (messageSource instanceof HttpListener || !ConnectorNotificationListener.this.resolveType(result, messageSource)) {
                        result.setConnector(NodeType.HTTP.getProcessorName());
                    }
                } else {
                    result.setConnector(NodeType.HTTP.getProcessorName());
                }
                result.setAction(action);
                result.setFlowName(notification.getResourceIdentifier());
                result.setProtocol(this.resolveProtocol(message));
                result.setRemoteHost(this.resolveRemoteIp(message));
                result.setClientId(this.resolveClientId(message));
                result.setHostHeader(this.getInboundPropertyAsString(message, ConnectorNotificationListener.HOST_HEADER));
                result.setEndpoint(this.getInboundPropertyAsString(message, ConnectorNotificationListener.REQUEST_PATH));
                result.setSourceHash(this.getInboundPropertyAsString(message, "x-anypnt-app-worker"));
                Set<Event<InvocationContext>> set = Collections.singleton(new Event<long>(notification.getTimestamp(), result));
                return set;
            }
            finally {
                AbstractListener.resetAccess(message);
            }
        }

        private String getInboundPropertyAsString(MuleMessage message, String prop) {
            Object value = message.getInboundProperty(prop);
            return value == null ? null : value.toString();
        }

        private String resolveProtocol(MuleMessage message) {
            Object scheme;
            String protocol = null;
            String xForwardedProtoHeader = this.getInboundPropertyAsString(message, ConnectorNotificationListener.X_FORWARDED_PROTO_HEADER);
            if (xForwardedProtoHeader != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found x-forwarded-proto header: " + xForwardedProtoHeader);
                }
                protocol = xForwardedProtoHeader.toLowerCase();
            }
            if (protocol == null && (scheme = message.getInboundProperty("http.scheme")) != null) {
                protocol = scheme.toString().toLowerCase();
            }
            return protocol;
        }

        private String resolveRemoteIp(MuleMessage message) {
            String remoteIp = null;
            String xForwardedIpHeader = this.getInboundPropertyAsString(message, ConnectorNotificationListener.X_FORWARDED_FOR_HEADER);
            if (xForwardedIpHeader != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found x-forwarded-for header: " + xForwardedIpHeader);
                }
                remoteIp = xForwardedIpHeader;
            } else {
                Matcher ipMatcher;
                Object remoteAddr = message.getInboundProperty("http.remote.address");
                if (remoteAddr != null && (ipMatcher = REMOTE_ADDRESS_PATTERN.matcher(remoteAddr.toString())).find()) {
                    remoteIp = ipMatcher.group(2);
                }
            }
            return remoteIp;
        }

        private String resolveClientId(MuleMessage message) {
            String clientId = (String)message.getInvocationProperty("_clientId");
            if (clientId != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Client-Id found via client_id property: " + clientId);
                }
            } else {
                AccessTokenStoreHolder accessTokenStoreHolder = (AccessTokenStoreHolder)message.getInvocationProperty("mule.oauth2.access_token_store_holder");
                if (accessTokenStoreHolder != null && accessTokenStoreHolder.getAccessToken() != null) {
                    clientId = accessTokenStoreHolder.getAccessToken().getClientId();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Client-Id found via token store property: " + clientId);
                    }
                }
            }
            return clientId;
        }

        private boolean isHttpFailure(MuleMessage message) {
            Object httpStatus = message.getOutboundProperty(ConnectorNotificationListener.HTTP_STATUS_PROP);
            if (httpStatus instanceof String) {
                return NumberUtils.toInt((String)((String)httpStatus), (int)0) >= 400;
            }
            return false;
        }
    }

    static class NotificationEnvelope {
        ConnectorMessageNotification notification;
        String invocationId;

        NotificationEnvelope() {
        }
    }
}

