/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OneTimeThreadExecutor {
    private EventPipeline<Void> startPipeline;

    public OneTimeThreadExecutor(final Runnable runnable) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadFactoryBuilder().setNameFormat("OneTime-AsyncProcessor-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.startPipeline = EventPipeline.startWith(new AsyncProcessor(executor)).endWith(new EventConsumer<Void>(){

            @Override
            public void consume(Event<Void> event) {
                runnable.run();
                OneTimeThreadExecutor.this.startPipeline.stop();
            }
        });
        this.startPipeline.start();
    }

    public void trigger() {
        this.startPipeline.submit(new Event<Object>(null));
    }
}

