/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.config.model.FileContent;
import com.mulesoft.analytics.collector.config.model.HarvesterConfig;
import com.mulesoft.analytics.collector.config.model.HarvesterType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.joda.time.DateTimeZone;

@Singleton
public class FilebeatConfigurator {
    private static final Logger LOGGER = LogManager.getLogger(FilebeatConfigurator.class);
    private static final String PROSPECTORS_DIR = "prospectors";
    private static final String APPLOG_TEMPLATE_FILE = "applog.template";
    private static final String METRIC_TEMPLATE_FILE = "metric.template";
    private static final String METRIC_CONFIG_FILE = "_metric.yml";
    private static final String FILEBEAT_CONFIG_FILE = "filebeat.yml";
    @Inject
    private Configuration configuration;

    private Path getProspectorsDir() {
        return this.configuration.getAmConfigPath().resolve(PROSPECTORS_DIR);
    }

    private Path getMetricConfigFile() {
        return this.getProspectorsDir().resolve(METRIC_CONFIG_FILE);
    }

    private Path getAppLogTemplateFile() {
        return this.configuration.getAmConfigPath().resolve(APPLOG_TEMPLATE_FILE);
    }

    private Path getMetricTemplateFile() {
        return this.configuration.getAmConfigPath().resolve(METRIC_TEMPLATE_FILE);
    }

    public void generateFilebeatConfigFile() {
        HarvesterConfig hc;
        if (this.configuration.getRuntimeConfig() != null && (hc = this.configuration.getRuntimeConfig().getHarvester()) != null && hc.getConfigFiles() != null) {
            if (HarvesterType.FILEBEAT.equals((Object)hc.getType())) {
                for (FileContent fc : hc.getConfigFiles()) {
                    if (fc.getName() == null || fc.getName().isEmpty() || fc.getContent() == null || fc.getContent().isEmpty()) continue;
                    try {
                        Path configFilePath = this.configuration.getAmConfigPath().resolve(fc.getName()).normalize();
                        if (configFilePath.startsWith(this.configuration.getAmConfigPath())) {
                            if (fc.getName().endsWith(FILEBEAT_CONFIG_FILE)) {
                                this.configureProxyUrl(fc);
                            }
                            FileUtils.write((File)configFilePath.toFile(), (CharSequence)fc.getContent(), (Charset)StandardCharsets.UTF_8, (boolean)false);
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal file path: " + configFilePath);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to generate filebeat config file: " + fc.getName(), (Throwable)e);
                    }
                }
            } else {
                LOGGER.warn("Unsupported HarvesterType: " + (Object)((Object)hc.getType()));
            }
        }
    }

    public void generateMetricLogConfigFile() {
        if (this.isConfigFileGenerationNeeded(this.getMetricTemplateFile(), this.getMetricConfigFile())) {
            try {
                this.generateConfigFile(this.getMetricTemplateFile(), this.getMetricConfigFile(), this.generateSubs(this.configuration.getMetricLogFileName(), null));
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate filebeat config file", (Throwable)e);
            }
        }
    }

    public void generateAppLogConfigFile(String appId, ClassLoader appClassLoader) {
        this.generateAppLogConfigFile(appId, (LoggerContext)LogManager.getContext((ClassLoader)appClassLoader, (boolean)true));
    }

    private void generateAppLogConfigFile(String appId, LoggerContext context) {
        Path appLogConfigFile = this.getAppLogConfigFile(appId);
        if (this.isConfigFileGenerationNeeded(this.getAppLogTemplateFile(), appLogConfigFile)) {
            try {
                String logFile = this.getApplicationLogFile(context);
                if (logFile == null) {
                    LOGGER.error("Cannot resolve application log file for app: " + appId);
                } else {
                    this.generateConfigFile(this.getAppLogTemplateFile(), appLogConfigFile, this.generateSubs(logFile, appId));
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate filebeat config file for app: " + appId, (Throwable)e);
            }
        }
    }

    public void deleteAppLogConfigFile(String appId) {
        if (this.configuration.getDeploymentType() == DeploymentType.HYBRID) {
            try {
                Files.deleteIfExists(this.getAppLogConfigFile(appId));
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete filebeat config file for app: " + appId, (Throwable)e);
            }
        }
    }

    private void configureProxyUrl(FileContent fc) {
        String proxyUrl = this.configuration.getProxyUrl();
        StringBuilder content = new StringBuilder();
        boolean logstashMatched = false;
        for (String line : fc.getContent().split("\\r?\\n")) {
            int position;
            if (!line.contains("proxy_url:")) {
                content.append(line).append(System.lineSeparator());
            }
            if (line.contains("output.logstash:")) {
                logstashMatched = true;
            }
            if (!logstashMatched || proxyUrl == null || (position = line.indexOf("hosts:")) == -1) continue;
            content.append(line, 0, position).append("proxy_url: ").append(proxyUrl).append(System.lineSeparator());
        }
        fc.setContent(content.toString());
    }

    boolean isConfigFileGenerationNeeded(Path templateFile, Path configFile) {
        if (!Files.isDirectory(this.configuration.getAmConfigPath(), new LinkOption[0])) {
            return false;
        }
        if (Files.isRegularFile(configFile, new LinkOption[0])) {
            LOGGER.info("Found " + configFile);
        } else if (!Files.isRegularFile(templateFile, new LinkOption[0])) {
            LOGGER.error("Not found " + templateFile);
        } else {
            return true;
        }
        return false;
    }

    private Path getAppLogConfigFile(String appId) {
        return this.getProspectorsDir().resolve(appId + ".yml");
    }

    private String getApplicationLogFile(LoggerContext context) {
        String logFile = null;
        for (Appender appender : context.getConfiguration().getAppenders().values()) {
            if (appender instanceof RollingFileAppender) {
                logFile = ((RollingFileAppender)appender).getFileName();
                continue;
            }
            if (!(appender instanceof FileAppender)) continue;
            logFile = ((FileAppender)appender).getFileName();
        }
        return logFile;
    }

    private void generateConfigFile(Path templateFile, Path configFile, Map<String, String> subs) throws IOException {
        List<String> input = Files.readAllLines(templateFile, StandardCharsets.UTF_8);
        ArrayList<String> output = new ArrayList<String>();
        for (String line : input) {
            line = StrSubstitutor.replaceSystemProperties((Object)line);
            for (Map.Entry<String, String> entry : subs.entrySet()) {
                String subValue;
                String string = subValue = entry.getValue() != null ? entry.getValue() : "";
                if (entry.getValue() == null) continue;
                line = StringUtils.replace((String)line, (String)entry.getKey(), (String)subValue);
            }
            output.add(line);
        }
        FileUtils.writeLines((File)configFile.toFile(), output);
    }

    private Map<String, String> generateSubs(String logFile, String appId) {
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put("${log.file}", logFile);
        if (appId != null) {
            subs.put("${app.id}", appId);
        }
        subs.put("${organization.id}", this.configuration.getOrgId());
        subs.put("${master.organization.id}", this.configuration.getMasterOrgId());
        subs.put("${environment.id}", this.configuration.getEnvId());
        subs.put("${environment.type}", this.configuration.getEnvType());
        subs.put("${server.id}", this.configuration.getRuntimeId());
        subs.put("${server.name}", this.configuration.getServerName());
        subs.put("${cluster.id}", this.configuration.getClusterId());
        subs.put("${time.zone}", DateTimeZone.getDefault().getID());
        return subs;
    }
}

