/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.log.MetricLogWriter;
import com.mulesoft.analytics.collector.metrics.EnvironmentProvider;
import com.mulesoft.analytics.collector.metrics.FactLogger;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.InvocationContextToFactTransformer;
import com.mulesoft.analytics.collector.metrics.LongAverageCalculator;
import com.mulesoft.analytics.collector.metrics.LongMetricDuplicator;
import com.mulesoft.analytics.collector.metrics.PathTagSanitizer;
import com.mulesoft.analytics.collector.metrics.PingEndpointFilter;
import com.mulesoft.analytics.collector.pipeline.AsyncProcessor;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactCombiner;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import com.mulesoft.analytics.collector.pipeline.ScheduledLimiterAndAggregator;
import com.mulesoft.analytics.collector.pipeline.SynchronizedStep;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;

@Singleton
public class PipelineRegistry {
    @Inject
    private Configuration configuration;
    @Inject
    private MetricLogWriter logWriter;
    @GuardedBy(value="pipelinesLock")
    private Multimap<String, EventPipeline<?>> mainPipelines = ArrayListMultimap.create();
    @GuardedBy(value="pipelinesLock")
    private Map<String, Map<FactMeta, EventPipeline<InvocationContext>>> commonPipelineMap = new HashMap<String, Map<FactMeta, EventPipeline<InvocationContext>>>();
    @GuardedBy(value="pipelinesLock")
    private Map<String, Map<String, EventPipeline<Fact>>> customPipelineMap = new HashMap<String, Map<String, EventPipeline<Fact>>>();
    private final Object pipelinesLock = new Object();
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private final Supplier<ExecutorService> executorSupplier = Suppliers.memoize((Supplier)new Supplier<ExecutorService>(){

        public ExecutorService get() {
            return new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(PipelineRegistry.this.configuration.getPrebufferMaxSize()), new ThreadFactoryBuilder().setNameFormat("Pipeline-AsyncProcessor-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> EventPipeline<T> createPipeline(String appId, FactMeta factMeta, EventMapper<T, InvocationContext> notificationMapper) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<T> pipeline = EventPipeline.startWith(notificationMapper).continueWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).endWith(this.getCommonPipeline(appId, factMeta, new FactLogger(this.logWriter)));
            pipeline.start();
            this.mainPipelines.put((Object)appId, pipeline);
            return pipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventPipeline<InvocationContext> getCommonPipeline(String appId, FactMeta factMeta, EventConsumer<Fact> eventConsumer) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<InvocationContext> pipeline;
            Map<FactMeta, EventPipeline<InvocationContext>> innerMap = this.commonPipelineMap.get(appId);
            if (innerMap == null) {
                innerMap = new HashMap<FactMeta, EventPipeline<InvocationContext>>();
                this.commonPipelineMap.put(appId, innerMap);
            }
            if ((pipeline = innerMap.get(factMeta)) == null) {
                pipeline = EventPipeline.startWith(new SynchronizedStep()).continueWith(new InvocationContextToFactTransformer(factMeta.getName())).continueWith(new FactCombiner(this.configuration.getCombinerMaxSize(), "response_type", "response_time")).continueWith(new PingEndpointFilter()).continueWith(new PathTagSanitizer("endpoint")).continueWith(new ScheduledLimiterAndAggregator((long)this.configuration.getAggregationTimeInterval(), factMeta, 1).setSamplingSize(5).setContainerSize(1000).setOtherValue(this.configuration.getOtherValue())).continueWith(new LongAverageCalculator("response_time", "avg_response_time")).continueWith(new LongMetricDuplicator("response_time.count", "avg_request_count")).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(eventConsumer);
                pipeline.start();
                innerMap.put(factMeta, pipeline);
            }
            return pipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPipeline<Fact> getCustomMetricPipeline(String appId, String metricName, FactMeta metricMeta) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            EventPipeline<Fact> pipeline;
            Map<String, EventPipeline<Fact>> appMap = this.customPipelineMap.get(appId);
            if (appMap == null) {
                appMap = new HashMap<String, EventPipeline<Fact>>();
                this.customPipelineMap.put(appId, appMap);
            }
            if ((pipeline = appMap.get(metricName)) == null) {
                pipeline = EventPipeline.startWith(new AsyncProcessor((ExecutorService)this.executorSupplier.get())).continueWith(new ScheduledLimiterAndAggregator((long)this.configuration.getAggregationTimeInterval(), metricMeta, this.configuration.getAggregationTopN()).setOtherValue(this.configuration.getOtherValue())).continueWith(new EnvironmentProvider(this.configuration, appId)).endWith(new FactLogger(this.logWriter));
                pipeline.start();
                appMap.put(metricName, pipeline);
            }
            return pipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String appId) {
        Object object = this.pipelinesLock;
        synchronized (object) {
            this.commonPipelineMap.remove(appId);
            for (EventPipeline p : this.mainPipelines.get((Object)appId)) {
                p.stop();
            }
            this.mainPipelines.removeAll((Object)appId);
            Map<String, EventPipeline<Fact>> customMetricPipelines = this.customPipelineMap.remove(appId);
            if (customMetricPipelines != null) {
                for (EventPipeline<Fact> p : customMetricPipelines.values()) {
                    p.stop();
                }
            }
        }
    }
}

