/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.PipelineStep;
import com.mulesoft.analytics.collector.pipeline.Step;
import com.mulesoft.analytics.collector.pipeline.TerminatingStep;
import com.mulesoft.analytics.collector.pipeline.TransformingStep;
import java.util.Collection;

public class EventPipeline<S> {
    private Step<S, ?> firstStep = null;

    private EventPipeline(Step<S, ?> firstStep) {
        this.firstStep = firstStep;
    }

    public static <I, O> Builder<I, I, O> startWith(Step<I, O> step) {
        return new Builder(step, step);
    }

    public static <I, O> Builder<I, I, O> startWith(EventMapper<I, O> transformer) {
        return EventPipeline.startWith(new TransformingStep<I, O>(transformer));
    }

    public void submit(Event<S> event) {
        this.firstStep.process(event);
    }

    public void submit(Collection<Event<S>> events) {
        for (Event<S> event : events) {
            this.firstStep.process(event);
        }
    }

    public void start() {
        Step<Object, ?> step = this.firstStep;
        while (step != null) {
            step.start();
            step = step.next;
        }
    }

    public void stop() {
        Step<Object, ?> step = this.firstStep;
        while (step != null) {
            step.stop();
            step = step.next;
        }
    }

    public static class Builder<S, I, O> {
        private Step<S, ?> firstStep = null;
        private Step<I, O> currentStep = null;

        private Builder(Step<S, ?> first, Step<I, O> current) {
            this.firstStep = first;
            this.currentStep = current;
        }

        public <T> Builder<S, O, T> continueWith(Step<O, T> nextStep) {
            this.currentStep.next = nextStep;
            return new Builder<S, O, T>(this.firstStep, nextStep);
        }

        public <T> Builder<S, O, T> continueWith(EventMapper<O, T> transformer) {
            return this.continueWith(new TransformingStep<O, T>(transformer));
        }

        public EventPipeline<S> endWith(EventConsumer<O> consumer) {
            TerminatingStep<O> finalStep = new TerminatingStep<O>(consumer);
            this.currentStep.setNext(finalStep);
            return new EventPipeline(this.firstStep);
        }

        public EventPipeline<S> endWith(EventPipeline<O> pipeline) {
            PipelineStep<O> finalStep = new PipelineStep<O>(pipeline);
            this.currentStep.setNext(finalStep);
            return new EventPipeline(this.firstStep);
        }
    }
}

