/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.processor;

import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessorConfig;
import com.mulesoft.analytics.limiter.UserEvent;
import com.mulesoft.analytics.limiter.processor.EventLimiter;
import com.mulesoft.analytics.limiter.processor.StrategyBuilder;
import com.mulesoft.analytics.limiter.strategy.EventLimiterStrategy;
import com.mulesoft.analytics.limiter.strategy.StrategyState;

public class EventLimiterImpl
implements EventLimiter {
    private int inputEventCount;
    private EventProcessorConfig config;
    private EventLimiterStrategy strategy;

    public EventLimiterImpl(EventProcessorConfig configuration) {
        this.configure(configuration);
        this.inputEventCount = 0;
        this.strategy = StrategyBuilder.getStrategy(configuration);
        this.strategy.begin();
    }

    @Override
    public void configure(EventProcessorConfig config) {
        this.config = config;
    }

    @Override
    public void append(UserEvent event) {
        ++this.inputEventCount;
        if (this.strategy.getBufferSize() >= this.config.getContainerSize() && this.strategy.getState() == StrategyState.COLLECTING_SAMPLES) {
            this.strategy.learn();
        }
        this.strategy.append(event);
    }

    @Override
    public int getInputEventCount() {
        return this.inputEventCount;
    }

    @Override
    public EventLimiterResult retrieveLimiterResult() {
        this.strategy.end();
        EventLimiterResult r = this.strategy.getResults();
        this.strategy.begin();
        return r;
    }
}

