/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventBatchMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.GroupByKeyReducer;
import java.util.Arrays;
import java.util.Collection;

public class FactCombiner
extends GroupByKeyReducer<Fact, Fact> {
    private String finalDimension;
    private String durationMetric;

    public FactCombiner(int maxSize, String finalDimension, String durationMetric) {
        super(maxSize, null);
        this.finalDimension = finalDimension;
        this.durationMetric = durationMetric;
        this.processor = new Transformer();
    }

    private class Transformer
    implements EventBatchMapper<Fact, Fact> {
        private Transformer() {
        }

        @Override
        public Collection<Event<Fact>> process(Collection<Event<Fact>> events) {
            Fact result = this.mergeFacts(events);
            if (result != null) {
                return Arrays.asList(new Event<long>(events.iterator().next().getTime(), result));
            }
            return null;
        }

        private Fact mergeFacts(Collection<Event<Fact>> events) {
            if (!this.isFinalDimensionPresent(events)) {
                return null;
            }
            Fact result = null;
            Event<Fact> firstEvent = null;
            Event<Fact> lastEvent = null;
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                if (result == null) {
                    result = new Fact(fact.getName());
                    firstEvent = event;
                }
                for (String name : fact.getDimensions()) {
                    result.setDimension(name, fact.getDimension(name));
                }
                lastEvent = event;
            }
            if (firstEvent != null && lastEvent != null && firstEvent != lastEvent) {
                result.setLongMetric(FactCombiner.this.durationMetric, lastEvent.getTime() - firstEvent.getTime());
                return result;
            }
            return null;
        }

        private boolean isFinalDimensionPresent(Collection<Event<Fact>> events) {
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                if (!fact.getDimensions().contains(FactCombiner.this.finalDimension)) continue;
                return true;
            }
            return false;
        }
    }
}

