/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;

public class ProcessorNotificationListener
extends AbstractListener
implements MessageProcessorNotificationListener<MessageProcessorNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ProcessorNotificationListener.class);
    private static final String PROCESSOR_REGEX = "^org\\.mule\\.runtime\\.(module|modules)\\.*";
    private final Pattern processorPattern = Pattern.compile("^org\\.mule\\.runtime\\.(module|modules)\\.*");
    private final EventPipeline<MessageProcessorNotification> metricPipeline;

    public ProcessorNotificationListener(PipelineRegistry pipelineRegistry, LogWriter logWriter, String appId) {
        this.metricPipeline = pipelineRegistry.createPipeline(appId, Metrics.OUTBOUND_INVOCATION, new MessageProcessorNotificationTransformer());
    }

    public void onNotification(MessageProcessorNotification notification) {
        this.metricPipeline.submit(new Event<MessageProcessorNotification>(notification));
    }

    private class MessageProcessorNotificationTransformer
    implements EventMapper<MessageProcessorNotification, InvocationContext> {
        private MessageProcessorNotificationTransformer() {
        }

        @Override
        public Collection<Event<InvocationContext>> process(Event<MessageProcessorNotification> event) {
            InvocationContext.Action action;
            MessageProcessorNotification notification = event.getValue();
            Component component = notification.getComponent();
            String componentId = AbstractListener.getComponentName(component);
            if (notification.getAction() == null || componentId == null) {
                return Collections.emptyList();
            }
            if (notification.getAction().getActionId() == 1601) {
                if (NodeType.HTTP.getProcessorName().equals(componentId)) {
                    return Collections.emptyList();
                }
                action = InvocationContext.Action.PRE_INVOKE;
            } else if (notification.getAction().getActionId() == 1602) {
                action = notification.getException() == null ? InvocationContext.Action.POST_INVOKE_SUCCESS : InvocationContext.Action.POST_INVOKE_ERROR;
            } else {
                return Collections.emptyList();
            }
            if (!ProcessorNotificationListener.this.processorPattern.matcher(component.getClass().getName()).find()) {
                return Collections.emptyList();
            }
            InvocationContext context = new InvocationContext();
            context.setAction(action);
            context.setInvocationId(AbstractListener.getInvocationId(notification.getEvent(), component));
            context.setFlowName(notification.getResourceIdentifier());
            NodeType type = NodeType.getTypeFromProcessor(componentId);
            if (NodeType.HTTP != type) {
                context.setRemoteHost(type.getHostNameFromType(componentId));
                context.setOperation(AbstractListener.getComponentOperation(component));
            }
            context.setConnector(type.getProcessorName());
            return Collections.singleton(new Event<long>(notification.getTimestamp(), context));
        }
    }
}

