/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.util;

import com.mulesoft.dias.ex.AgentConfiguratorException;
import com.mulesoft.dias.util.InstallerMessages;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MuleHomePath {
    private static String getMuleHome() {
        return System.getProperty("muleHome");
    }

    public static Path getConfigPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "conf", file);
    }

    public static Path getMule3AgentPluginPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "plugins", "mule-agent-plugin", "lib", file);
    }

    public static Path getMule4gentPluginPath() {
        return Paths.get(MuleHomePath.getMuleHome(), "server-plugins", "mule-agent-plugin", "lib");
    }

    public static Path getAMConfigPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "am", "config", file);
    }

    public static Path getAMLibPath(String file) {
        return Paths.get(MuleHomePath.getMuleHome(), "am", "lib", file);
    }

    public static Path getMuleLibPath(String file) {
        Path p = MuleHomePath.getPath(MuleHomePath.getMuleHome(), "lib", "mule", file);
        if (p != null) {
            return p;
        }
        throw new AgentConfiguratorException(InstallerMessages.invalidMuleLibPath());
    }

    private static Path getPath(String first, String ... more) {
        try {
            Path p = Paths.get(first, more);
            return p != null && p.toFile().exists() ? p : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

