/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.application.properties.AgentApplicationPropertiesService;
import com.mulesoft.analytics.collector.agent.ApiMetadataExtractor;
import com.mulesoft.analytics.collector.agent.AppStatsHandler;
import com.mulesoft.analytics.collector.agent.CollectorAgentBase;
import com.mulesoft.analytics.collector.agent.ConnectorNotificationListener;
import com.mulesoft.analytics.collector.agent.CustomNotificationListener;
import com.mulesoft.analytics.collector.agent.HttpExtensionNotificationListener;
import com.mulesoft.analytics.collector.agent.ProcessorNotificationListener;
import com.mulesoft.analytics.collector.policy.PolicyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.analytics.collector")
@Singleton
public class CollectorAgentService
extends CollectorAgentBase
implements MuleAgentService,
DeploymentServiceAware,
Startable,
Stoppable {
    @Inject
    private List<InternalMessageHandler<?>> messageHandlerList = Collections.emptyList();
    @Inject
    private AgentApplicationPropertiesService agentApplicationPropertiesService;
    @Nullable
    private AppStatsHandler appStatsHandler;
    @Inject
    protected ApiMetadataExtractor apiMetadataExtractor;
    @Nullable
    private DeploymentService deploymentService;
    @Nullable
    private DeploymentListener deploymentListener;
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ConnectorNotificationListener> connectorListeners = new HashMap<String, ConnectorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, ProcessorNotificationListener> processorListeners = new HashMap<String, ProcessorNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, HttpExtensionNotificationListener> extensionListeners = new HashMap<String, HttpExtensionNotificationListener>();
    @GuardedBy(value="notificationListenersLock")
    private final Map<String, CustomNotificationListener> customListeners = new HashMap<String, CustomNotificationListener>();
    private final Object notificationListenersLock = new Object();

    public void start() {
        this.startCollector(4);
        if (this.deploymentService != null) {
            if (this.deploymentListener == null) {
                this.deploymentListener = new CollectorDeploymentListener();
            }
            this.deploymentService.addDeploymentListener(this.deploymentListener);
        }
    }

    @Override
    protected void onCollectorStart() {
        this.registerListenersForAllApps();
        for (InternalMessageHandler<?> handler : this.messageHandlerList) {
            if (!(handler instanceof AppStatsHandler)) continue;
            this.appStatsHandler = (AppStatsHandler)handler;
            break;
        }
    }

    public void stop() {
        this.stopCollector();
    }

    @Override
    protected void onCollectorStop() {
        this.unregisterListenersForAllApps();
    }

    public void setDeploymentService(@Nullable DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.messageHandlerList);
    }

    private void registerListeners(String appId, Registry registry) {
        if (registry != null) {
            registry.lookupByType(NotificationListenerRegistry.class).ifPresent(notificationsRegistry -> {
                try {
                    LOGGER.info("Registering listeners for application {}", (Object)appId);
                    String overrideAppId = this.configuration.overrideAppId(appId);
                    if (overrideAppId == null) {
                        return;
                    }
                    Object object = this.notificationListenersLock;
                    synchronized (object) {
                        if (!this.connectorListeners.containsKey(overrideAppId)) {
                            ConnectorNotificationListener connectorListener = new ConnectorNotificationListener(this.pipelineRegistry, overrideAppId);
                            notificationsRegistry.registerListener((NotificationListener)connectorListener);
                            this.connectorListeners.put(overrideAppId, connectorListener);
                        }
                        if (!this.processorListeners.containsKey(overrideAppId)) {
                            ProcessorNotificationListener processorListener = new ProcessorNotificationListener(this.pipelineRegistry, this.logWriter, overrideAppId);
                            notificationsRegistry.registerListener((NotificationListener)processorListener);
                            this.processorListeners.put(overrideAppId, processorListener);
                        }
                        if (!this.extensionListeners.containsKey(overrideAppId)) {
                            HttpExtensionNotificationListener extensionListener = new HttpExtensionNotificationListener(this.pipelineRegistry, this.logWriter, overrideAppId);
                            notificationsRegistry.registerListener((NotificationListener)extensionListener);
                            this.extensionListeners.put(overrideAppId, extensionListener);
                        }
                        if (!this.customListeners.containsKey(overrideAppId)) {
                            CustomNotificationListener customListener = new CustomNotificationListener(this.customMetricHandler, overrideAppId);
                            notificationsRegistry.registerListener((NotificationListener)customListener);
                            this.customListeners.put(overrideAppId, customListener);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not register listeners for application " + appId, (Throwable)e);
                }
            });
        }
    }

    void registerListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                this.registerListeners(app.getArtifactName(), app.getRegistry());
                this.filebeatConfig.generateAppLogConfigFile(app.getArtifactName(), (ClassLoader)app.getRegionClassLoader());
            }
        }
    }

    void unregisterListenersForAllApps() {
        if (this.deploymentService != null) {
            for (Application app : this.deploymentService.getApplications()) {
                Registry registry = app.getRegistry();
                if (registry == null) continue;
                registry.lookupByType(NotificationListenerRegistry.class).ifPresent(notificationsRegistry -> {
                    String appId = this.configuration.overrideAppId(app.getArtifactName());
                    if (appId != null) {
                        LOGGER.info("Un-registering listeners for application {}", (Object)appId);
                        Object object = this.notificationListenersLock;
                        synchronized (object) {
                            CustomNotificationListener customListener;
                            HttpExtensionNotificationListener extensionListener;
                            ConnectorNotificationListener connectorListener;
                            ProcessorNotificationListener processorListener = this.processorListeners.remove(appId);
                            if (processorListener != null) {
                                notificationsRegistry.unregisterListener((NotificationListener)processorListener);
                            }
                            if ((connectorListener = this.connectorListeners.remove(appId)) != null) {
                                notificationsRegistry.unregisterListener((NotificationListener)connectorListener);
                            }
                            if ((extensionListener = this.extensionListeners.remove(appId)) != null) {
                                notificationsRegistry.unregisterListener((NotificationListener)extensionListener);
                            }
                            if ((customListener = this.customListeners.remove(appId)) != null) {
                                notificationsRegistry.unregisterListener((NotificationListener)customListener);
                            }
                        }
                    }
                });
            }
            if (this.deploymentListener != null) {
                this.deploymentService.removeDeploymentListener(this.deploymentListener);
                this.deploymentListener = null;
            }
        }
    }

    private void registerHeaderInjectionPolicy(String appName, Application app) {
        if (this.configuration.isHeaderInjectionDisabled()) {
            return;
        }
        if ((appName = this.configuration.overrideAppId(appName)) == null) {
            return;
        }
        String workerHash = this.configuration.generateWorkerHash(appName);
        if (workerHash == null) {
            return;
        }
        try {
            ApplicationPolicyManager policyManager = app.getPolicyManager();
            PolicyUtils.registerHeaderInjectionPolicy(policyManager, workerHash);
        }
        catch (Exception e) {
            LOGGER.error("Failed to register http-header-injection policy for app: " + appName + ". This may affect Anypoint Visualization functionality", (Throwable)e);
        }
    }

    private void provideAppStatsExtraFields(String appName, Registry registry) {
        if (this.appStatsHandler != null) {
            this.appStatsHandler.addApiIds(this.configuration.overrideAppId(appName), this.apiMetadataExtractor.getApiIds(registry));
            this.appStatsHandler.setMuleVersion(MuleManifest.getProductVersion());
        }
    }

    private class CollectorDeploymentListener
    implements DeploymentListener {
        private CollectorDeploymentListener() {
        }

        public void onDeploymentSuccess(String appName) {
            CollectorAgentService.this.completeDelayedInitialization();
            if (CollectorAgentService.this.configuration.isEnabled()) {
                CollectorAgentService.this.configuration.setAppDeployed(appName);
                if (CollectorAgentService.this.agentApplicationPropertiesService != null) {
                    CollectorAgentService.this.configuration.addAppSpecificProperties(appName, CollectorAgentService.this.agentApplicationPropertiesService.getPropertiesForApplication(appName));
                }
                if (CollectorAgentService.this.deploymentService != null) {
                    Application app = CollectorAgentService.this.deploymentService.findApplication(appName);
                    if (app != null) {
                        Registry registry = app.getRegistry();
                        CollectorAgentService.this.registerListeners(appName, registry);
                        CollectorAgentService.this.registerHeaderInjectionPolicy(appName, app);
                        CollectorAgentService.this.provideAppStatsExtraFields(appName, registry);
                        CollectorAgentService.this.filebeatConfig.generateAppLogConfigFile(appName, (ClassLoader)app.getRegionClassLoader());
                    } else {
                        CollectorAgentBase.LOGGER.error("Application not found: " + appName);
                    }
                }
            }
        }

        public void onUndeploymentStart(String appName) {
            CollectorAgentService.this.pipelineRegistry.unregister(appName);
            if (CollectorAgentService.this.appStatsHandler != null) {
                CollectorAgentService.this.appStatsHandler.unregisterApp(appName);
            }
            CollectorAgentService.this.customMetricHandler.unregister(appName);
            CollectorAgentService.this.filebeatConfig.deleteAppLogConfigFile(appName);
            CollectorAgentService.this.configuration.removeAppSpecificProperties(appName);
            CollectorAgentService.this.configuration.setAppUndeployed(appName);
        }
    }
}

