/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.analytics.collector.log.LogWriter;
import com.mulesoft.analytics.collector.metrics.BatcherSettings;
import com.mulesoft.analytics.collector.metrics.JsonBatchGenerator;
import com.mulesoft.analytics.collector.metrics.MetricEvent;
import com.mulesoft.analytics.collector.metrics.MetricEventUtils;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventConsumer;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonFactLogger
implements EventConsumer<Fact> {
    private static final Logger LOGGER = LogManager.getLogger(JsonFactLogger.class);
    private final FactMeta factMeta;
    private final EventProducer<Fact> commonsProducer;
    private final long collectionInterval;
    private final LogWriter output;
    private final ImmutableMap<String, BatcherSettings> batcherSettingsMap;
    private final JsonFactory jsonFactory;
    @Nullable
    private Future<?> scheduledTask;
    @GuardedBy(value="metricBatcherLock")
    private final Map<ImmutableMap<String, String>, JsonBatchGenerator> generatorMap = new HashMap<ImmutableMap<String, String>, JsonBatchGenerator>();
    @GuardedBy(value="metricBatcherLock")
    private final Map<ImmutableMap<String, String>, MutableBoolean> needStartBatchMap = new HashMap<ImmutableMap<String, String>, MutableBoolean>();
    @GuardedBy(value="metricBatcherLock")
    private final Map<ImmutableMap<String, String>, MutableLong> lastBatchTimeMap = new HashMap<ImmutableMap<String, String>, MutableLong>();
    private final Object metricBatcherLock = new Object();

    JsonFactLogger(FactMeta factMeta, EventProducer<Fact> commonsProducer, ScheduledExecutorService executor, long collectionInterval, LogWriter output, ImmutableMap<String, BatcherSettings> batcherSettingsMap) {
        this(factMeta, commonsProducer, executor, collectionInterval, output, new JsonFactory(), batcherSettingsMap);
    }

    JsonFactLogger(FactMeta factMeta, EventProducer<Fact> commonsProducer, ScheduledExecutorService executor, long collectionInterval, LogWriter output, JsonFactory jsonFactory, ImmutableMap<String, BatcherSettings> batcherSettingsMap) {
        this.factMeta = factMeta;
        this.commonsProducer = commonsProducer;
        this.collectionInterval = collectionInterval;
        this.output = output;
        this.batcherSettingsMap = batcherSettingsMap;
        this.jsonFactory = jsonFactory;
        this.scheduledTask = executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                JsonFactLogger.this.writeBatcher();
            }
        }, collectionInterval, collectionInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Event<Fact> event) {
        MetricEvent metricEvent = MetricEventUtils.convert(this.factMeta, event, this.batcherSettingsMap);
        if (metricEvent.getFacts().isEmpty()) {
            return;
        }
        Object object = this.metricBatcherLock;
        synchronized (object) {
            try {
                MutableLong lastBatchTime;
                ImmutableMap<String, String> commons = metricEvent.getCommons();
                JsonBatchGenerator generator = this.generatorMap.get(commons);
                MutableBoolean needStartBatch = this.needStartBatchMap.get(commons);
                if (needStartBatch == null) {
                    needStartBatch = new MutableBoolean(true);
                    this.needStartBatchMap.put(commons, needStartBatch);
                }
                if ((lastBatchTime = this.lastBatchTimeMap.get(commons)) == null) {
                    lastBatchTime = new MutableLong(0L);
                    this.lastBatchTimeMap.put(commons, lastBatchTime);
                }
                if (generator == null || needStartBatch.isTrue() && metricEvent.getTime() - lastBatchTime.longValue() >= this.collectionInterval) {
                    BatcherSettings batcherSettings = (BatcherSettings)this.batcherSettingsMap.get((Object)metricEvent.getType());
                    if (batcherSettings == null) {
                        batcherSettings = new BatcherSettings(false, Collections.emptySet());
                    }
                    if (!(generator = new JsonBatchGenerator(this.commonsProducer, metricEvent, this.jsonFactory, batcherSettings)).startBatch()) {
                        return;
                    }
                    lastBatchTime.setValue(metricEvent.getTime());
                    needStartBatch.setFalse();
                    this.generatorMap.put(commons, generator);
                }
                if (needStartBatch.isTrue()) {
                    generator.startNextBatch();
                    needStartBatch.setFalse();
                }
                generator.putEvent(metricEvent);
                if (generator.isBatchLimitReached()) {
                    this.output.write(generator.generateJson());
                    generator.startNextBatch();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to process event", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBatcher() {
        Object object = this.metricBatcherLock;
        synchronized (object) {
            for (Map.Entry<ImmutableMap<String, String>, JsonBatchGenerator> entry : this.generatorMap.entrySet()) {
                ImmutableMap<String, String> commons = entry.getKey();
                JsonBatchGenerator generator = entry.getValue();
                if (!generator.isBatchStarted()) continue;
                try {
                    this.output.write(generator.generateJson());
                    this.needStartBatchMap.put(commons, new MutableBoolean(true));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to write JSON batch", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.metricBatcherLock;
        synchronized (object) {
            this.writeBatcher();
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
                this.scheduledTask = null;
            }
        }
    }
}

