/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventBatchMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.GroupByKeyReducer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class FactCombiner
extends GroupByKeyReducer<Fact, Fact> {
    private String finalDimension;
    private String durationMetric;

    public FactCombiner(int maxSize, String finalDimension, String durationMetric) {
        super(maxSize, null);
        this.finalDimension = finalDimension;
        this.durationMetric = durationMetric;
        this.processor = new Transformer();
    }

    private class Transformer
    implements EventBatchMapper<Fact, Fact> {
        private Transformer() {
        }

        @Override
        @Nullable
        public Collection<Event<Fact>> process(Collection<Event<Fact>> events) {
            Fact result = this.mergeFacts(events);
            if (result != null) {
                return Arrays.asList(new Event<long>(events.iterator().next().getTime(), result));
            }
            return null;
        }

        @Nullable
        private Fact mergeFacts(Collection<Event<Fact>> events) {
            if (!this.isFinalDimensionPresent(events)) {
                return null;
            }
            Fact result = null;
            Event<Fact> firstEvent = null;
            Event<Fact> lastEvent = null;
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                if (result == null) {
                    result = new Fact();
                    firstEvent = event;
                }
                for (Map.Entry<String, String> entry : fact.getDimensionMap().entrySet()) {
                    result.setDimension(entry.getKey(), entry.getValue());
                }
                for (String name : fact.getLongMetrics()) {
                    result.setLongMetric(name, fact.getLongMetric(name));
                }
                for (String name : fact.getDoubleMetrics()) {
                    result.setDoubleMetric(name, fact.getDoubleMetric(name));
                }
                lastEvent = event;
            }
            if (result != null && firstEvent != null && lastEvent != null && firstEvent != lastEvent) {
                result.setLongMetric(FactCombiner.this.durationMetric, Math.max(lastEvent.getTime() - firstEvent.getTime(), 0L));
                return result;
            }
            return null;
        }

        private boolean isFinalDimensionPresent(Collection<Event<Fact>> events) {
            for (Event<Fact> event : events) {
                Fact fact = event.getValue();
                if (!fact.getDimensions().contains(FactCombiner.this.finalDimension)) continue;
                return true;
            }
            return false;
        }
    }
}

