/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.dias.configurator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.dias.mule.agent.MuleAgentConfig;
import com.mulesoft.dias.service.AuthenticationProxyClient;
import com.mulesoft.dias.service.DefaultAuthenticationProxyFactory;
import com.mulesoft.dias.service.ProxyServerFactory;
import com.mulesoft.dias.util.ConsoleLogger;
import com.mulesoft.dias.util.InstallerMessages;
import com.mulesoft.dias.util.MuleHomePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;

public class AgentConfigurator {
    private static final String PROVISIONING_CONFIG_REGISTER = "/dias/provisioning/register/api/v1";

    public void pushConfiguration() throws IOException, URISyntaxException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        String agentConfig = new String(Files.readAllBytes(MuleHomePath.getConfigPath("mule-agent.yml")));
        MuleAgentConfig muleAgent = new MuleAgentConfig(agentConfig);
        String keyStorePassword = muleAgent.getKeyStorePassword();
        String authenticationProxyEndpoint = muleAgent.getAuthenticationProxyEndpoint();
        if (keyStorePassword == null || authenticationProxyEndpoint == null) {
            ConsoleLogger.error(InstallerMessages.agentConfigPropertyMissing());
            System.exit(-1);
        }
        String authProxyEndpoint = authenticationProxyEndpoint;
        DefaultAuthenticationProxyFactory defaultAuthenticationProxyFactory = new DefaultAuthenticationProxyFactory();
        URI uri = new URI(authProxyEndpoint);
        AuthenticationProxyClient authenticationProxyClient = defaultAuthenticationProxyFactory.create(keyStorePassword, new ObjectMapper(), uri);
        Response response = this.pushConfigurationToArm(muleAgent, authenticationProxyClient);
        AgentConfigurator.validatePushConfigurationResponse(response);
        authenticationProxyClient.close();
    }

    private Response pushConfigurationToArm(MuleAgentConfig muleAgent, AuthenticationProxyClient authenticationProxyClient) {
        String proxyHost = muleAgent.getProxyHost();
        Integer proxyPort = muleAgent.getProxyPort();
        if (proxyHost == null && proxyPort == null) {
            return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER);
        }
        if (proxyHost == null || proxyPort == null) {
            ConsoleLogger.error(InstallerMessages.proxyConfigMissing());
            System.exit(-1);
        }
        String proxyUser = muleAgent.getProxyUser();
        String proxyPassword = muleAgent.getProxyPassword();
        ProxyServer.Builder proxyBuilder = new ProxyServerFactory().create(proxyHost, proxyPort, proxyUser != null ? proxyUser : "", proxyPassword != null ? proxyPassword : "");
        return authenticationProxyClient.post(PROVISIONING_CONFIG_REGISTER, proxyBuilder.build());
    }

    private static void validatePushConfigurationResponse(Response response) throws IOException {
        int responseCode = response.getStatusCode();
        if (responseCode == 200) {
            ConsoleLogger.info(InstallerMessages.agentConfigSuccessfully());
        } else if (responseCode == 401) {
            ConsoleLogger.error(InstallerMessages.unauthorized());
        } else {
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed request with code ").append(responseCode).append(".");
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseBodyAsStream()));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            ConsoleLogger.error(stringBuilder.toString());
        }
    }
}

