/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.UserEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Fact
implements UserEvent {
    private final Map<String, String> dimensions;
    private final Map<String, Long> longMetrics;
    private final Map<String, Double> doubleMetrics;
    private final boolean aggregated;
    private final boolean limited;

    public Fact() {
        this(new HashMap<String, String>(), new HashMap<String, Long>(), new HashMap<String, Double>(), false, false);
    }

    public Fact(boolean aggregated, boolean limited) {
        this(new HashMap<String, String>(), new HashMap<String, Long>(), new HashMap<String, Double>(), aggregated, limited);
    }

    public Fact(Map<String, String> dimensions) {
        this(dimensions, new HashMap<String, Long>(), new HashMap<String, Double>(), false, false);
    }

    public Fact(Map<String, String> dimensions, Map<String, Long> longMetrics, Map<String, Double> doubleMetrics, boolean aggregated, boolean limited) {
        this.dimensions = dimensions;
        this.longMetrics = longMetrics;
        this.doubleMetrics = doubleMetrics;
        this.aggregated = aggregated;
        this.limited = limited;
    }

    public String toString() {
        return "Fact[dimensions=" + this.dimensions + ", longMetrics=" + this.longMetrics + ", doubleMetrics=" + this.doubleMetrics + ", aggregated=" + this.aggregated + ", limited=" + this.limited + "]";
    }

    public Set<String> getDimensions() {
        return this.dimensions.keySet();
    }

    public Map<String, String> getDimensionMap() {
        return new HashMap<String, String>(this.dimensions);
    }

    @Nullable
    public String getDimension(String name) {
        return this.dimensions.get(name);
    }

    public void setDimension(String name, @Nullable String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.dimensions.put(name, value);
        } else {
            this.dimensions.remove(name);
        }
    }

    public Set<String> getLongMetrics() {
        return this.longMetrics.keySet();
    }

    @Nullable
    public Long getLongMetric(String name) {
        return this.longMetrics.get(name);
    }

    public void setLongMetric(String name, @Nullable Long value) {
        if (value != null) {
            this.longMetrics.put(name, value);
        } else {
            this.longMetrics.remove(name);
        }
    }

    public Set<String> getDoubleMetrics() {
        return this.doubleMetrics.keySet();
    }

    @Nullable
    public Double getDoubleMetric(String name) {
        return this.doubleMetrics.get(name);
    }

    public void setDoubleMetric(String name, @Nullable Double value) {
        if (value != null) {
            this.doubleMetrics.put(name, value);
        } else {
            this.doubleMetrics.remove(name);
        }
    }

    @Override
    @Nullable
    public Object getDimensionValue(NamePath dimName) {
        return this.getDimension(dimName.toString());
    }

    @Override
    public Object[] getDimensionValues(NamePath[] dimNames) {
        Object[] result = new Object[dimNames.length];
        for (int i = 0; i < dimNames.length; ++i) {
            result[i] = this.getDimensionValue(dimNames[i]);
        }
        return result;
    }

    @Override
    public long[] getLongMetrics(NamePath[] metricNames) {
        long[] result = new long[metricNames.length];
        for (int i = 0; i < metricNames.length; ++i) {
            result[i] = (Long)ObjectUtils.defaultIfNull((Object)this.getLongMetric(metricNames[i].toString()), (Object)0L);
        }
        return result;
    }

    @Override
    public double[] getDoubleMetrics(NamePath[] metricNames) {
        double[] result = new double[metricNames.length];
        for (int i = 0; i < metricNames.length; ++i) {
            result[i] = (Double)ObjectUtils.defaultIfNull((Object)this.getDoubleMetric(metricNames[i].toString()), (Object)0.0);
        }
        return result;
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    public boolean isLimited() {
        return this.limited;
    }
}

