/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.agent.JMXMetricParser;
import com.mulesoft.analytics.collector.agent.JMXOperatingSystemMetricProvider;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.dias.jvm")
@Singleton
public class JMXMetricHandler
extends AbstractMessageHandler
implements InternalMessageHandler<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(JMXMetricHandler.class);
    @Inject
    private JMXMetricParser jmxParser;
    @Inject
    private JMXOperatingSystemMetricProvider metricProvider;

    public boolean handle(ArrayList<Metric> message) {
        String appId;
        if (!this.isEnabled() || message == null) {
            return false;
        }
        List<Tuple<String, String>> tags = this.createBaseTags();
        if ((this.configuration.getDeploymentType() == DeploymentType.CLOUDHUB || this.configuration.getDeploymentType() == DeploymentType.RTF) && (appId = this.configuration.overrideAppId(null)) != null) {
            tags.add(Tuple.tuple("app_id", appId));
        }
        for (Metric metric : message) {
            this.parseAndWrite(metric, tags);
        }
        for (MetricRecord record : this.metricProvider.getMetrics(tags)) {
            this.output.write(record.toString());
        }
        return true;
    }

    private void parseAndWrite(Metric metric, List<Tuple<String, String>> tags) {
        Number value = metric.getValue();
        String name = metric.getName();
        try {
            MetricRecord record = this.jmxParser.parse(name, value, tags);
            if (null != record) {
                this.output.write(record.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Unable to parse metric string '%s'", name), (Throwable)e);
        }
    }
}

