/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.mulesoft.analytics.collector.config.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class GeoDbDownloader {
    private static final Logger LOGGER = LogManager.getLogger(GeoDbDownloader.class);
    @Inject
    private Configuration configuration;

    public void download() {
        block9: {
            try {
                FileUtils.forceMkdir((File)this.configuration.getGeoDbPath().toFile());
                String downloadUrl = this.configuration.getGeoDbDownloadUrl();
                String downloadFileChecksum = this.configuration.getGeoDbChecksum();
                if (downloadUrl == null || downloadFileChecksum == null || this.configuration.isGeoDbCurrent()) break block9;
                LOGGER.info("Downloading geo location database");
                Path geoDbPath = this.configuration.getGeoDbPath();
                String zipFilename = StringUtils.substringAfterLast((String)downloadUrl, (String)"/");
                String zipTmpFilename = zipFilename + ".tmp";
                File zipTmpFile = geoDbPath.resolve(zipTmpFilename).toFile();
                FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)zipTmpFile);
                Thread.sleep(1000L);
                Hasher hasher = Hashing.md5().newHasher();
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(zipTmpFile));){
                    ByteStreams.copy((InputStream)gzipInputStream, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                }
                if (downloadFileChecksum.equals(hasher.hash().toString())) {
                    LOGGER.info("Checksum matched. Enabling geohash lookup with database file {}.", (Object)zipFilename);
                    GeoDbDownloader.deleteExistingGeoDbFiles(this.configuration.getGeoDbPath());
                    FileUtils.moveFile((File)zipTmpFile, (File)geoDbPath.resolve(zipFilename).toFile());
                    this.configuration.resetApiGeohashMetricPipeline();
                } else {
                    LOGGER.error("Checksum mismatch");
                    FileUtils.deleteQuietly((File)zipTmpFile);
                }
            }
            catch (Exception e) {
                LOGGER.error("Geo location database download failed", (Throwable)e);
            }
        }
    }

    static void deleteExistingGeoDbFiles(Path geoDbPath) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(geoDbPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return Configuration.LOCATION_DB_MATCHER.matches(entry);
            }
        });){
            for (Path filePath : stream) {
                Files.delete(filePath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete existing location database files", (Throwable)e);
        }
    }
}

