/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertiesUtil {
    public static final int getInt(Properties prop, String key, int defaultValue) {
        Object value = prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public static final double getDouble(Properties prop, String key, double defaultValue) {
        Object value = prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public static final String getString(Properties prop, String key, String defaultValue) {
        Object value = prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public static final String[] getStringArray(Properties prop, String key, char delimiter, String[] defaultValue) {
        Object value = prop.get(key);
        if (value == null) {
            return defaultValue;
        }
        String listValue = String.valueOf(value);
        String[] result = StringUtils.split((String)listValue, (char)delimiter);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i] != null ? result[i].trim() : null;
        }
        return result;
    }

    public static final String convertToList(String[] tokens, char delmiter) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == null) continue;
            out.append(delmiter).append(tokens[i]);
        }
        return out.length() > 0 ? out.substring(1) : "";
    }

    public static final Iterator<String> findKeys(Properties prop, String keyPrefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object key : prop.keySet()) {
            String keyString;
            if (key == null || !StringUtils.startsWith((CharSequence)(keyString = String.valueOf(key)), (CharSequence)keyPrefix)) continue;
            result.add(keyString);
        }
        return result.iterator();
    }
}

