/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter.data;

import com.mulesoft.analytics.limiter.MetricAggregate;
import com.mulesoft.analytics.limiter.NamePath;
import java.util.Arrays;

public class LongAggregate
implements MetricAggregate {
    private NamePath metricName;
    private long[] values = null;

    public LongAggregate(NamePath metricName) {
        this.metricName = metricName;
    }

    @Override
    public NamePath getMetricName() {
        return this.metricName;
    }

    @Override
    public boolean isDoubleMetric() {
        return false;
    }

    @Override
    public double[] getAsDouble() {
        return null;
    }

    @Override
    public long[] getAsLong() {
        return this.values;
    }

    @Override
    public void appendDouble(double number) {
    }

    @Override
    public void appendLong(long number) {
        if (this.values == null) {
            this.values = new long[4];
            this.values[2] = number;
            this.values[3] = number;
            this.values[0] = number;
            this.values[1] = number * number;
        } else {
            if (number < this.values[2]) {
                this.values[2] = number;
            }
            if (number > this.values[3]) {
                this.values[3] = number;
            }
            this.values[0] = this.values[0] + number;
            this.values[1] = this.values[1] + number * number;
        }
    }

    public String toString() {
        return this.metricName + "=" + Arrays.toString(this.values);
    }

    @Override
    public MetricAggregate duplicate() {
        LongAggregate result = new LongAggregate(this.metricName);
        if (this.values != null) {
            result.values = Arrays.copyOf(this.values, this.values.length);
        }
        return result;
    }

    @Override
    public void merge(MetricAggregate o) {
        LongAggregate other = (LongAggregate)o;
        if (this.values == null) {
            if (other.values != null) {
                this.values = Arrays.copyOf(other.values, other.values.length);
            }
        } else if (other.values != null) {
            this.values[0] = this.values[0] + other.values[0];
            this.values[1] = this.values[1] + other.values[1];
            if (other.values[2] < this.values[2]) {
                this.values[2] = other.values[2];
            }
            if (other.values[3] > this.values[3]) {
                this.values[3] = other.values[3];
            }
        }
    }
}

