/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Supplier;
import com.mulesoft.analytics.collector.util.MuleUtils;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;

public class RamlBasedEndpointTemplateSupplier
implements Supplier<List<String>> {
    private static String APIKIT_FLOW_SUFFIX = ":api-config";
    private final String appId;
    private final Registry muleRegistry;

    public RamlBasedEndpointTemplateSupplier(String appId, Registry muleRegistry) {
        this.appId = appId;
        this.muleRegistry = muleRegistry;
    }

    public List<String> get() {
        ArrayList<String> result = new ArrayList<String>();
        MuleUtils.registryLookupByType(this.appId, this.muleRegistry, AllStatistics.class).ifPresent(allStats -> {
            for (FlowConstructStatistics flowStats : allStats.getServiceStatistics()) {
                int firstColonPos;
                String flowName = flowStats.getName();
                if (!flowName.endsWith(APIKIT_FLOW_SUFFIX) || (firstColonPos = (flowName = flowName.substring(0, flowName.length() - APIKIT_FLOW_SUFFIX.length())).indexOf(":")) <= 0) continue;
                String template = flowName.substring(firstColonPos + 1);
                template = template.replace('(', '{');
                template = template.replace(')', '}');
                template = template.replace('\\', '/');
                result.add(template);
            }
        });
        return result;
    }
}

