/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.geo;

import com.mulesoft.analytics.collector.geo.GeohashLookup;
import com.mulesoft.analytics.collector.shaded.db.CHMCache;
import com.mulesoft.analytics.collector.shaded.geohash.GeoHash;
import com.mulesoft.analytics.collector.shaded.geoip2.DatabaseReader;
import com.mulesoft.analytics.collector.shaded.geoip2.record.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeohashLookupImpl
implements GeohashLookup {
    private static final Logger LOGGER = LogManager.getLogger(GeohashLookupImpl.class);
    private final DatabaseReader db;
    private static final int GEOHASH_LENGTH = 6;

    public GeohashLookupImpl(File databaseFile) throws IOException {
        this.db = new DatabaseReader.Builder(new GZIPInputStream(new FileInputStream(databaseFile))).withCache(new CHMCache()).build();
    }

    @Override
    @Nullable
    public String geohash(@Nullable String address) {
        try {
            Location location = this.db.city(InetAddress.getByName(address)).getLocation();
            return GeoHash.geoHashStringWithCharacterPrecision(location.getLatitude(), location.getLongitude(), 6);
        }
        catch (Exception e) {
            LOGGER.debug("Location lookup failed", (Throwable)e);
            return null;
        }
    }
}

