/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.pipeline;

import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventCollector;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.pipeline.FactMeta;
import com.mulesoft.analytics.collector.pipeline.ScheduledReducer;
import com.mulesoft.analytics.collector.pipeline.SynchronizedEventCollector;
import com.mulesoft.analytics.limiter.DefaultEventProcessorBuilder;
import com.mulesoft.analytics.limiter.EventAggregate;
import com.mulesoft.analytics.limiter.EventLimiterResult;
import com.mulesoft.analytics.limiter.EventProcessor;
import com.mulesoft.analytics.limiter.MetricAggregate;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.data.StringNamePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ScheduledLimiterAndAggregator
extends ScheduledReducer<Fact, Fact> {
    private static final String METRIC_SUFFIX_MIN = ".min";
    private static final String METRIC_SUFFIX_MAX = ".max";
    private static final String METRIC_SUFFIX_SUM = ".sum";
    private static final String METRIC_SUFFIX_SOS = ".sos";
    private static final String METRIC_SUFFIX_COUNT = ".count";
    private static final String DEFAULT_OTHER = "other";
    private final int maxOutput;
    private final FactMeta factMeta;
    private String otherValue = "other";
    private int containerSize = -1;
    private int samplingSize = -1;

    public ScheduledLimiterAndAggregator(ScheduledExecutorService executor, long delay, long period, FactMeta factMeta, int maxOutput) {
        super(executor, delay, period);
        this.factMeta = factMeta;
        this.maxOutput = maxOutput;
    }

    public ScheduledLimiterAndAggregator(ScheduledExecutorService executor, long period, FactMeta factMeta, int maxOutput) {
        this(executor, 0L, period, factMeta, maxOutput);
    }

    public ScheduledLimiterAndAggregator setContainerSize(int containerSize) {
        this.containerSize = containerSize;
        return this;
    }

    public ScheduledLimiterAndAggregator setSamplingSize(int samplingSize) {
        this.samplingSize = samplingSize;
        return this;
    }

    public ScheduledLimiterAndAggregator setOtherValue(String otherValue) {
        this.otherValue = otherValue;
        return this;
    }

    @Override
    protected void start() {
        this.collector = new SynchronizedEventCollector<Fact, Fact>(new EventAggregator(this.maxOutput, this.containerSize, this.samplingSize, this.otherValue, this.factMeta));
        super.start();
    }

    private static NamePath[] toNamePathArray(Collection<String> names) {
        NamePath[] result = new NamePath[names.size()];
        int i = 0;
        for (String name : names) {
            result[i] = new StringNamePath(name);
            ++i;
        }
        return result;
    }

    public static String toCountMetric(String baseMetric) {
        return baseMetric + METRIC_SUFFIX_COUNT;
    }

    public static String toMinMetric(String baseMetric) {
        return baseMetric + METRIC_SUFFIX_MIN;
    }

    public static String toMaxMetric(String baseMetric) {
        return baseMetric + METRIC_SUFFIX_MAX;
    }

    public static String toSumMetric(String baseMetric) {
        return baseMetric + METRIC_SUFFIX_SUM;
    }

    public static String toSosMetric(String baseMetric) {
        return baseMetric + METRIC_SUFFIX_SOS;
    }

    private static class EventAggregator
    implements EventCollector<Fact, Fact> {
        private final NamePath[] retainingDimensions;
        private final String otherValue;
        private final EventProcessor dataLimiterProcessor;

        EventAggregator(int maxOutput, int containerSize, int samplingSize, String otherValue, FactMeta factMeta) {
            this.retainingDimensions = ScheduledLimiterAndAggregator.toNamePathArray(factMeta.getRetainingDimensions());
            this.otherValue = otherValue;
            DefaultEventProcessorBuilder builder = new DefaultEventProcessorBuilder().setStrategy(StrategyType.ADAPTIVE_TOP_N).setMaxOutput(maxOutput);
            if (containerSize >= 0) {
                builder.setContainerSize(containerSize);
            }
            if (samplingSize >= 0) {
                builder.setSamplingSize(samplingSize);
            } else {
                builder.setContainerSize(maxOutput * 2);
            }
            for (NamePath np : this.retainingDimensions) {
                builder.addRetainingDimension(np);
            }
            for (NamePath np : ScheduledLimiterAndAggregator.toNamePathArray(factMeta.getCollapsibleDimensions())) {
                builder.addCollapsibleDimension(np);
            }
            for (NamePath np : ScheduledLimiterAndAggregator.toNamePathArray(factMeta.getLongMetrics())) {
                builder.addLongMetric(np);
            }
            for (NamePath np : ScheduledLimiterAndAggregator.toNamePathArray(factMeta.getDoubleMetrics())) {
                builder.addDoubleMetric(np);
            }
            this.dataLimiterProcessor = builder.build();
        }

        @Override
        public void add(Event<Fact> event) {
            this.dataLimiterProcessor.append(Collections.singleton(event.getValue()));
        }

        @Override
        public Collection<Event<Fact>> collect() {
            ArrayList<Event<Fact>> result = new ArrayList<Event<Fact>>();
            long time = System.currentTimeMillis();
            List<EventLimiterResult> list = this.dataLimiterProcessor.retrieveProcessorResult().getLimiterResults();
            for (EventLimiterResult elr : list) {
                EventAggregate[] aggregates = elr.getEventAggregates();
                if (aggregates == null) continue;
                for (EventAggregate aggregate : aggregates) {
                    Fact fact = new Fact(elr.isAggregated(), elr.isLimited());
                    if (aggregate.getEventCount() <= 0) continue;
                    this.collectRetainingDimensions(aggregate, fact);
                    this.collectCollapsibleDimensions(aggregate, fact);
                    this.collectMetricAggregates(aggregate, fact);
                    result.add(new Event<long>(time, fact));
                }
            }
            return result;
        }

        private void collectRetainingDimensions(EventAggregate aggregate, Fact fact) {
            for (NamePath np : this.retainingDimensions) {
                Object value = aggregate.getSampleEvent().getDimensionValue(np);
                if (value == null) continue;
                fact.setDimension(np.toString(), value.toString());
            }
        }

        private void collectCollapsibleDimensions(EventAggregate aggregate, Fact fact) {
            NamePath[] collapsibleDimensions = aggregate.getCollapsibleDimensions();
            Object[] collapsibleValues = aggregate.getCollapsibleValues();
            if (collapsibleDimensions != null) {
                for (int i = 0; i < collapsibleDimensions.length; ++i) {
                    if (collapsibleValues[i] == null) continue;
                    String val = collapsibleValues[i] == EventAggregate.OTHER ? this.otherValue : collapsibleValues[i].toString();
                    fact.setDimension(collapsibleDimensions[i].toString(), val);
                }
            }
        }

        private void collectMetricAggregates(EventAggregate aggregate, Fact fact) {
            MetricAggregate[] metricAggregates = aggregate.getMetricAggregates();
            if (metricAggregates != null) {
                for (MetricAggregate ma : metricAggregates) {
                    Object[] values;
                    String metricBase = ma.getMetricName().toString();
                    String countMetricName = ScheduledLimiterAndAggregator.toCountMetric(metricBase);
                    fact.setLongMetric(countMetricName, Long.valueOf(aggregate.getEventCount()));
                    String sumMetricName = ScheduledLimiterAndAggregator.toSumMetric(metricBase);
                    String sumOfSquaresMetricName = ScheduledLimiterAndAggregator.toSosMetric(metricBase);
                    String minMetricName = ScheduledLimiterAndAggregator.toMinMetric(metricBase);
                    String maxMetricName = ScheduledLimiterAndAggregator.toMaxMetric(metricBase);
                    if (ma.isDoubleMetric()) {
                        values = ma.getAsDouble();
                        fact.setDoubleMetric(minMetricName, values[2]);
                        fact.setDoubleMetric(maxMetricName, values[3]);
                        fact.setDoubleMetric(sumMetricName, values[0]);
                        fact.setDoubleMetric(sumOfSquaresMetricName, values[1]);
                        continue;
                    }
                    values = ma.getAsLong();
                    fact.setLongMetric(minMetricName, (long)values[2]);
                    fact.setLongMetric(maxMetricName, (long)values[3]);
                    fact.setLongMetric(sumMetricName, (long)values[0]);
                    fact.setLongMetric(sumOfSquaresMetricName, (long)values[1]);
                }
            } else {
                fact.setLongMetric("count", Long.valueOf(aggregate.getEventCount()));
            }
        }
    }
}

