/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.io.IOException;
import org.asynchttpclient.exception.TooManyConnectionsException;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import org.asynchttpclient.netty.channel.NonBlockingSemaphoreInfinite;
import org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;
import org.asynchttpclient.util.ThrowableUtil;

public class MaxConnectionSemaphore
implements ConnectionSemaphore {
    private final NonBlockingSemaphoreLike freeChannels;
    private final IOException tooManyConnections;

    MaxConnectionSemaphore(int maxConnections) {
        this.tooManyConnections = ThrowableUtil.unknownStackTrace(new TooManyConnectionsException(maxConnections), MaxConnectionSemaphore.class, "acquireChannelLock");
        this.freeChannels = maxConnections > 0 ? new NonBlockingSemaphore(maxConnections) : NonBlockingSemaphoreInfinite.INSTANCE;
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        if (!this.freeChannels.tryAcquire()) {
            throw this.tooManyConnections;
        }
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
    }
}

