/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.config;

import com.mulesoft.analytics.collector.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Singleton
public class DownloaderProxyClient {
    private static final Logger LOGGER = LogManager.getLogger(DownloaderProxyClient.class);
    private static final String GLOBAL_CONFIG = "globalConfiguration";
    private static final String PROXY_CONFIG = "proxyConfiguration";
    private static final String PROXY_HOST = "host";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "user";
    private static final String PROXY_PASS = "password";
    @Inject
    private Configuration configuration;
    @Nullable
    CloseableHttpClient httpClient;

    public boolean readProxyConfig() {
        try {
            Map proxyConfigMap;
            String muleAgentConfig = new String(Files.readAllBytes(this.configuration.getMuleAgentYmlPath()));
            Yaml yaml = new Yaml();
            Map muleAgentConfigMap = (Map)yaml.load(muleAgentConfig);
            Map globalConfigMap = (Map)muleAgentConfigMap.get(GLOBAL_CONFIG);
            if (globalConfigMap != null && (proxyConfigMap = (Map)globalConfigMap.get(PROXY_CONFIG)) != null) {
                String proxyHost = (String)proxyConfigMap.get(PROXY_HOST);
                Integer proxyPort = (Integer)proxyConfigMap.get(PROXY_PORT);
                String proxyUser = (String)proxyConfigMap.get(PROXY_USER);
                String proxyPass = (String)proxyConfigMap.get(PROXY_PASS);
                if (proxyHost != null && proxyPort != null) {
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxyHost, proxyPort.intValue()));
                    HttpClientBuilder builder = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner);
                    if (proxyUser != null && proxyPass != null) {
                        BasicCredentialsProvider provider = new BasicCredentialsProvider();
                        provider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
                        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                    }
                    this.httpClient = builder.build();
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to read proxy configuration", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadToFile(String downloadUrl, File targetFile) throws IOException {
        if (this.httpClient != null) {
            HttpGet request = new HttpGet(downloadUrl);
            try {
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                try (InputStream is = entity.getContent();){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)targetFile);
                }
            }
            finally {
                this.httpClient.close();
                this.httpClient = null;
            }
        }
    }
}

