/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.log;

import com.mulesoft.analytics.collector.log.LogWriter;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractLogWriter
implements LogWriter {
    public static final String LINE_PATTERN = "%m%n";
    @GuardedBy(value="loggerLock")
    @Nullable
    private Logger logger;
    @GuardedBy(value="loggerLock")
    @Nullable
    private LoggerContext context;
    private final Object loggerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String line) {
        Object object = this.loggerLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.info(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String loggerName, String fileName, String filePattern, String fileSize, String maxFiles) {
        String appenderName = loggerName + "__Appender";
        Object object = this.loggerLock;
        synchronized (object) {
            if (this.context != null) {
                return;
            }
            this.context = new LoggerContext(loggerName);
            this.context.start();
            Configuration ctxConfig = this.context.getConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withPattern(LINE_PATTERN).build();
            SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)fileSize);
            CompositeTriggeringPolicy triggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{policy});
            DefaultRolloverStrategy strategy = DefaultRolloverStrategy.createStrategy((String)maxFiles, null, null, null, null, (boolean)false, (Configuration)ctxConfig);
            RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)new RollingFileAppender.Builder().withFileName(fileName).withStrategy((RolloverStrategy)strategy).withName(appenderName)).withFilePattern(filePattern).withLayout((Layout)layout)).withPolicy((TriggeringPolicy)triggeringPolicy).build();
            appender.start();
            ctxConfig.addAppender((Appender)appender);
            AppenderRef ref = AppenderRef.createAppenderRef((String)appenderName, null, null);
            AppenderRef[] refs = new AppenderRef[]{ref};
            LoggerConfig loggerConfig = AsyncLoggerConfig.createLogger((String)"false", (String)Level.INFO.name(), (String)loggerName, (String)"false", (AppenderRef[])refs, null, (Configuration)ctxConfig, null);
            loggerConfig.addAppender((Appender)appender, Level.INFO, null);
            ctxConfig.addLogger(loggerName, loggerConfig);
            this.context.updateLoggers();
            this.logger = this.context.getLogger(loggerName);
        }
    }

    public abstract void init(com.mulesoft.analytics.collector.config.Configuration var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.loggerLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            this.logger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Logger getLogger() {
        Object object = this.loggerLock;
        synchronized (object) {
            return this.logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLogger(Logger logger) {
        Object object = this.loggerLock;
        synchronized (object) {
            this.logger = logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    LoggerContext getContext() {
        Object object = this.loggerLock;
        synchronized (object) {
            return this.context;
        }
    }
}

