/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.shaded.geohash;

import java.io.Serializable;

public class WGS84Point
implements Serializable {
    private static final long serialVersionUID = 7457963026513014856L;
    private final double longitude;
    private final double latitude;

    public WGS84Point(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The supplied coordinates " + this + " are out of range.");
        }
    }

    public WGS84Point(WGS84Point other) {
        this(other.latitude, other.longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return String.format("(" + this.latitude + "," + this.longitude + ")", new Object[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WGS84Point) {
            WGS84Point other = (WGS84Point)obj;
            return this.latitude == other.latitude && this.longitude == other.longitude;
        }
        return false;
    }

    public int hashCode() {
        int result = 42;
        long latBits = Double.doubleToLongBits(this.latitude);
        long lonBits = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(latBits ^ latBits >>> 32);
        result = 31 * result + (int)(lonBits ^ lonBits >>> 32);
        return result;
    }
}

