/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.util;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;

public class MuleUtils {
    public static final Logger LOGGER = LogManager.getLogger(MuleUtils.class);

    private MuleUtils() {
    }

    public static <T> Optional<T> registryLookupByType(String appId, Registry registry, Class<T> objectType) {
        try {
            return registry.lookupByType(objectType);
        }
        catch (Exception e) {
            LOGGER.warn("Mule registry lookup failed for app " + appId, (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<RegionClassLoader> getAppRegionClassLoader(Application app) {
        try {
            return Optional.ofNullable(app.getRegionClassLoader());
        }
        catch (Exception e) {
            LOGGER.warn("Get app region class loader failed for app " + app.getArtifactName(), (Throwable)e);
            return Optional.empty();
        }
    }
}

