/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Supplier;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.util.HttpUtils;
import com.mulesoft.analytics.collector.util.ResettableSupplier;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractApiGatewayHttpEventHandler<T>
extends AbstractMessageHandler
implements InternalMessageHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractApiGatewayHttpEventHandler.class);
    private static final DateTimeFormatter ISO_8601_TIME_PARSER = ISODateTimeFormat.dateTime();
    @Inject
    private PipelineRegistry pipelineRegistry;
    private final ResettableSupplier<EventPipeline<HttpEventDelegate>> pipelineSupplier = new ResettableSupplier<EventPipeline<HttpEventDelegate>>(new Supplier<EventPipeline<HttpEventDelegate>>(){

        public EventPipeline<HttpEventDelegate> get() {
            return AbstractApiGatewayHttpEventHandler.this.pipelineRegistry.createApiMetricsPipeline(new AnalyticsHttpEventTransformer());
        }
    });

    public boolean handle(T httpEvent) {
        if (!this.isEnabled() || httpEvent == null || this.configuration.getApiMetricsLevel() == Configuration.ApiMetricsLevel.NONE) {
            return false;
        }
        if (this.configuration.shouldResetApiMetricsPipeline()) {
            LOGGER.info("Resetting API Metrics pipeline");
            this.pipelineSupplier.reset();
        }
        try {
            this.pipelineSupplier.get().submit(new Event<HttpEventDelegate>(this.wrap(httpEvent)));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to process HTTP event for API metrics", (Throwable)e);
            return false;
        }
    }

    protected abstract HttpEventDelegate wrap(T var1);

    private class AnalyticsHttpEventTransformer
    implements EventMapper<HttpEventDelegate, Fact> {
        private AnalyticsHttpEventTransformer() {
        }

        @Override
        public Collection<Event<Fact>> process(Event<HttpEventDelegate> event) {
            int statusCode;
            HttpEventDelegate httpEvent = event.getValue();
            Fact fact = new Fact();
            HttpEventDelegate.RequestDisposition requestDisposition = httpEvent.getRequestDisposition();
            if (requestDisposition != null) {
                if (requestDisposition == HttpEventDelegate.RequestDisposition.PROCESSED && AbstractApiGatewayHttpEventHandler.this.configuration.getApiMetricsLevel() == Configuration.ApiMetricsLevel.BLOCKED) {
                    return Collections.emptyList();
                }
                fact.setDimension("request_disposition", requestDisposition.toString().toLowerCase());
            }
            if (!HttpUtils.isErrorStatusCode(statusCode = httpEvent.getStatusCode()) && AbstractApiGatewayHttpEventHandler.this.configuration.getApiMetricsLevel() == Configuration.ApiMetricsLevel.FAILED) {
                return Collections.emptyList();
            }
            fact.setDimension("status_code", String.valueOf(statusCode));
            this.setHttpTags(httpEvent, fact);
            this.setApiTags(httpEvent, fact);
            this.setPolicyTags(httpEvent, fact);
            this.setSizingInfo(httpEvent, fact);
            try {
                this.setTimingInfo(httpEvent, fact);
            }
            catch (ParseException e) {
                LOGGER.error("Failed to parse time in ISO 8601 format in event: {}", (Object)httpEvent.toString());
                return Collections.emptyList();
            }
            return Collections.singleton(new Event<Fact>(fact));
        }

        private void setHttpTags(HttpEventDelegate httpEvent, Fact fact) {
            String clientId = httpEvent.getClientId();
            fact.setDimension("client_id", clientId);
            String clientApp = httpEvent.getClientApp();
            fact.setDimension("client_app", clientApp);
            String clientIp = httpEvent.getClientIp();
            fact.setDimension("remote_host", clientIp);
            String verb = httpEvent.getVerb();
            fact.setDimension("method", verb);
            String userAgent = httpEvent.getUserAgent();
            fact.setDimension("user_agent", userAgent);
            String path = httpEvent.getPath();
            fact.setDimension("path", StringUtils.substringBefore((String)path, (String)"?"));
        }

        private void setApiTags(HttpEventDelegate httpEvent, Fact fact) {
            String apiId = httpEvent.getApiId();
            fact.setDimension("api_id", apiId);
            String apiVersionId = httpEvent.getApiVersionId();
            fact.setDimension("api_version_id", apiVersionId);
            String apiName = httpEvent.getApiName();
            fact.setDimension("api_name", apiName);
            String apiVersion = httpEvent.getApiVersion();
            fact.setDimension("api_version", apiVersion);
            String apiInstanceLabel = httpEvent.getApiInstanceLabel();
            fact.setDimension("api_instance_label", apiInstanceLabel);
        }

        private void setPolicyTags(HttpEventDelegate httpEvent, Fact fact) {
            String id = httpEvent.getPolicyId();
            fact.setDimension("policy_id", id);
            String name = httpEvent.getPolicyName();
            fact.setDimension("policy_name", name);
            String outcome = httpEvent.getPolicyOutcome();
            fact.setDimension("policy_outcome", outcome);
        }

        private void setTimingInfo(HttpEventDelegate httpEvent, Fact fact) throws ParseException {
            String received = httpEvent.getReceivedTs();
            String replied = httpEvent.getRepliedTs();
            long receivedTs = this.toEpocTime(received);
            long repliedTs = this.toEpocTime(replied);
            long delta = repliedTs - receivedTs;
            fact.setLongMetric("_time", receivedTs);
            fact.setLongMetric("response_time", Math.max(delta, 0L));
        }

        private void setSizingInfo(HttpEventDelegate httpEvent, Fact fact) {
            int responseSize;
            int requestSize = httpEvent.getRequestBytes();
            if (requestSize >= 0) {
                fact.setLongMetric("request_size", Long.valueOf(requestSize));
            }
            if ((responseSize = httpEvent.getResponseBytes()) >= 0) {
                fact.setLongMetric("response_size", Long.valueOf(responseSize));
            }
        }

        private long toEpocTime(String iso8601dateTime) throws ParseException {
            try {
                return ISO_8601_TIME_PARSER.parseMillis(iso8601dateTime);
            }
            catch (Exception e) {
                throw new ParseException(iso8601dateTime, 0);
            }
        }
    }

    protected static interface HttpEventDelegate {
        @Nullable
        public RequestDisposition getRequestDisposition();

        public int getStatusCode();

        public int getRequestBytes();

        public int getResponseBytes();

        public String getClientId();

        public String getClientApp();

        public String getClientIp();

        public String getVerb();

        public String getPath();

        public String getUserAgent();

        public String getApiId();

        public String getApiName();

        public String getApiVersion();

        @Nullable
        public String getApiVersionId();

        @Nullable
        public String getApiInstanceLabel();

        @Nullable
        public String getPolicyId();

        @Nullable
        public String getPolicyName();

        @Nullable
        public String getPolicyOutcome();

        public String getReceivedTs();

        public String getRepliedTs();

        public static enum RequestDisposition {
            PROCESSED,
            BLOCKED;

        }
    }
}

