/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mulesoft.analytics.collector.agent.AbstractApiGatewayHttpEventHandler;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.RequestDisposition;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="mule.agent.analytics.gw_http_events")
@Singleton
public class ApiGatewayHttpEventHandler
extends AbstractApiGatewayHttpEventHandler<AnalyticsHttpEvent> {
    @Override
    protected AbstractApiGatewayHttpEventHandler.HttpEventDelegate wrap(AnalyticsHttpEvent target) {
        return new HttpEventDelegateImpl(target);
    }

    private static class HttpEventDelegateImpl
    implements AbstractApiGatewayHttpEventHandler.HttpEventDelegate {
        private static ImmutableMap<RequestDisposition, AbstractApiGatewayHttpEventHandler.HttpEventDelegate.RequestDisposition> requestDispositionMap = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)RequestDisposition.PROCESSED, (Object)((Object)AbstractApiGatewayHttpEventHandler.HttpEventDelegate.RequestDisposition.PROCESSED), (Object)RequestDisposition.BLOCKED, (Object)((Object)AbstractApiGatewayHttpEventHandler.HttpEventDelegate.RequestDisposition.BLOCKED)));
        private AnalyticsHttpEvent delegate;

        private HttpEventDelegateImpl(AnalyticsHttpEvent delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        @Nullable
        public AbstractApiGatewayHttpEventHandler.HttpEventDelegate.RequestDisposition getRequestDisposition() {
            return (AbstractApiGatewayHttpEventHandler.HttpEventDelegate.RequestDisposition)((Object)requestDispositionMap.get((Object)this.delegate.getRequestDisposition()));
        }

        @Override
        public int getStatusCode() {
            return this.delegate.getStatusCode();
        }

        @Override
        public int getRequestBytes() {
            return this.delegate.getRequestBytes();
        }

        @Override
        public int getResponseBytes() {
            return this.delegate.getResponseBytes();
        }

        @Override
        public String getClientId() {
            return this.delegate.getClientId();
        }

        @Override
        public String getClientApp() {
            return this.delegate.getApplicationName();
        }

        @Override
        public String getClientIp() {
            return this.delegate.getClientIp();
        }

        @Override
        public String getVerb() {
            return this.delegate.getVerb();
        }

        @Override
        public String getPath() {
            return this.delegate.getPath();
        }

        @Override
        public String getUserAgent() {
            return this.delegate.getUserAgent();
        }

        @Override
        public String getApiId() {
            return Objects.toString(this.delegate.getApiId(), null);
        }

        @Override
        public String getApiName() {
            return this.delegate.getApiName();
        }

        @Override
        public String getApiVersion() {
            return this.delegate.getApiVersion();
        }

        @Override
        @Nullable
        public String getApiVersionId() {
            return Objects.toString(this.delegate.getApiVersionId(), null);
        }

        @Override
        @Nullable
        public String getApiInstanceLabel() {
            return this.delegate.getInstanceName();
        }

        @Override
        @Nullable
        public String getPolicyId() {
            PolicyViolation pv = this.delegate.getPolicyViolation();
            return pv != null ? pv.getPolicyId() : null;
        }

        @Override
        @Nullable
        public String getPolicyName() {
            PolicyViolation pv = this.delegate.getPolicyViolation();
            return pv != null ? pv.getPolicyName() : null;
        }

        @Override
        @Nullable
        public String getPolicyOutcome() {
            PolicyViolation pv = this.delegate.getPolicyViolation();
            return pv != null ? Objects.toString(pv.getOutcome(), null) : null;
        }

        @Override
        public String getReceivedTs() {
            return this.delegate.getReceivedTs();
        }

        @Override
        public String getRepliedTs() {
            return this.delegate.getRepliedTs();
        }
    }
}

