/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import com.mulesoft.analytics.collector.util.HttpUtils;
import com.mulesoft.analytics.collector.util.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.api.util.MultiMap;

public class ConnectorNotificationListener
extends AbstractListener
implements ConnectorMessageNotificationListener<ConnectorMessageNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ConnectorNotificationListener.class);
    private final EventPipeline<ConnectorMessageNotification> metricPipeline;

    public ConnectorNotificationListener(PipelineRegistry pipelineRegistry, String appId) {
        this(pipelineRegistry, appId, null);
    }

    public ConnectorNotificationListener(PipelineRegistry pipelineRegistry, String appId, @Nullable Supplier<List<String>> endpointTemplateSupplier) {
        this.metricPipeline = pipelineRegistry.createInboundPipelineInfo(appId, new ConnectorMessageNotificationTransformer(), endpointTemplateSupplier).getPipeline();
    }

    public void onNotification(ConnectorMessageNotification notification) {
        LOGGER.debug("ConnectorMessageNotification: {}", (Object)notification);
        this.metricPipeline.submit(new com.mulesoft.analytics.collector.pipeline.Event<ConnectorMessageNotification>(notification));
    }

    private class ConnectorMessageNotificationTransformer
    implements EventMapper<ConnectorMessageNotification, InvocationContext> {
        private ConnectorMessageNotificationTransformer() {
        }

        @Override
        public Collection<com.mulesoft.analytics.collector.pipeline.Event<InvocationContext>> process(com.mulesoft.analytics.collector.pipeline.Event<ConnectorMessageNotification> event) {
            InvocationContext.Action action;
            ConnectorMessageNotification notification = event.getValue();
            if (notification.getAction() == null) {
                LOGGER.debug("No action from notification");
                return Collections.emptyList();
            }
            switch (notification.getAction().getActionId()) {
                case 801: {
                    action = InvocationContext.Action.PRE_INVOKE;
                    break;
                }
                case 805: {
                    action = InvocationContext.Action.POST_INVOKE_SUCCESS;
                    break;
                }
                case 806: {
                    action = InvocationContext.Action.POST_INVOKE_ERROR;
                    break;
                }
                default: {
                    LOGGER.debug("Unsupported action: {}", (Object)notification.getAction().getActionId());
                    return Collections.emptyList();
                }
            }
            Component component = notification.getComponent();
            if (component == null) {
                LOGGER.debug("No component from notification");
                return Collections.emptyList();
            }
            Event notificationEvent = notification.getEvent();
            if (notificationEvent == null) {
                LOGGER.debug("No event from notification");
                return Collections.emptyList();
            }
            if (notificationEvent.getMessage() == null || notificationEvent.getContext() == null || notificationEvent.getContext().getId() == null) {
                LOGGER.debug("No event message or event context from notification");
                return Collections.emptyList();
            }
            String componentId = AbstractListener.getComponentName(component);
            NodeType type = NodeType.getTypeFromProcessor(componentId);
            if (NodeType.OTHER == type) {
                LOGGER.debug("Connector type not supported: {}", (Object)componentId);
                return Collections.emptyList();
            }
            InvocationContext context = new InvocationContext();
            context.setConnector(type.getProcessorName());
            context.setAction(action);
            context.setInvocationId(this.processInvocationId(notification.getEvent().getContext().getId()));
            context.setFlowName(notification.getResourceIdentifier());
            if (NodeType.HTTP == type) {
                if (action == InvocationContext.Action.PRE_INVOKE) {
                    if (!this.populateHttpAttributes(notificationEvent, context)) {
                        return Collections.emptyList();
                    }
                } else {
                    notificationEvent.getAuthentication().ifPresent(auth -> {
                        Object val = Maps.emptyIfNull(auth.getProperties()).get("clientId");
                        if (val instanceof String) {
                            context.setClientId((String)val);
                        }
                    });
                }
            } else {
                context.setRemoteHost(type.getHostNameFromType(componentId));
                context.setOperation(AbstractListener.getComponentOperation(component));
            }
            LOGGER.debug("Inbound invocation: {}", (Object)context);
            return Collections.singleton(new com.mulesoft.analytics.collector.pipeline.Event<long>(notification.getTimestamp(), context));
        }

        private String processInvocationId(String id) {
            Preconditions.checkNotNull((Object)id);
            if (id.length() > 36) {
                return id.substring(0, 36);
            }
            return id;
        }

        private boolean populateHttpAttributes(Event notificationEvent, InvocationContext context) {
            try {
                TypedValue httpRequestAttributesTV = notificationEvent.getMessage().getAttributes();
                if (httpRequestAttributesTV == null) {
                    LOGGER.debug("Missing HttpRequestAttributes");
                    return false;
                }
                Object httpRequestAttributes = httpRequestAttributesTV.getValue();
                String requestPath = AbstractListener.invokeViaReflection(httpRequestAttributes, "getRequestPath", Object.class).toString();
                context.setEndpoint(requestPath);
                String listenerPath = Objects.toString(AbstractListener.invokeViaReflection(httpRequestAttributes, "getListenerPath", Object.class), null);
                context.setBasePath(HttpUtils.extractBasePath(listenerPath));
                MultiMap headers = AbstractListener.invokeViaReflection(httpRequestAttributes, "getHeaders", MultiMap.class);
                if (headers != null) {
                    if (headers.containsKey((Object)"x-anypnt-app-worker")) {
                        context.setSourceHash((String)headers.get((Object)"x-anypnt-app-worker"));
                    }
                    if (headers.containsKey((Object)"host")) {
                        context.setHostHeader((String)headers.get((Object)"host"));
                    }
                }
                if (headers != null && headers.containsKey((Object)"x-forwarded-for") && headers.containsKey((Object)"x-forwarded-proto")) {
                    context.setRemoteHost((String)headers.get((Object)"x-forwarded-for"));
                    context.setProtocol(((String)headers.get((Object)"x-forwarded-proto")).toLowerCase());
                } else {
                    String remoteHost;
                    Object remoteAddress;
                    Object scheme = AbstractListener.invokeViaReflection(httpRequestAttributes, "getScheme", Object.class);
                    if (scheme != null) {
                        context.setProtocol(scheme.toString().toLowerCase());
                    }
                    if ((remoteAddress = AbstractListener.invokeViaReflection(httpRequestAttributes, "getRemoteAddress", Object.class)) != null && (remoteHost = HttpUtils.parseHttpRemoteAddress(remoteAddress.toString())) != null) {
                        context.setRemoteHost(remoteHost);
                    }
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.debug("Exception while extracting inbound data", (Throwable)e);
                return false;
            }
        }
    }
}

