/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.analytics.collector.metrics.BatcherSettings;
import com.mulesoft.analytics.collector.metrics.MetricEvent;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventProducer;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class JsonBatchGenerator {
    private final EventProducer<Fact> commonsProducer;
    private final long time;
    private final String type;
    private final ImmutableMap<String, String> commons;
    private final JsonFactory jsonFactory;
    private final BatcherSettings batcherSettings;
    private int currentBatchId = 0;
    private int numEvents = 0;
    private boolean aggregated = false;
    private boolean limited = false;
    @Nullable
    private ByteArrayOutputStream out;
    @Nullable
    private JsonGenerator jsonGenerator;
    private static final int MAX_BATCH_SIZE = 100;
    private static final int MAX_JSON_SIZE = 15000;
    private static final String FORMAT_FIELD = "format";
    private static final String TIME_FIELD = "time";
    private static final String TYPE_FIELD = "type";
    private static final String COMMONS_FIELD = "commons";
    private static final String EVENTS_FIELD = "events";
    private static final String DIMENSIONS_FIELD = "dimensions";
    private static final String FACTS_FIELD = "facts";
    private static final String METADATA_FIELD = "metadata";
    private static final String BATCH_ID_FIELD = "batch_id";
    private static final String AGGREGATED_FIELD = "aggregated";
    private static final String LIMITED_FIELD = "limited";
    private static final String PRODUCER_NAME_FIELD = "producer_name";
    private static final String PRODUCER_VERSION_FIELD = "producer_version";
    private static final String METRIC_FORMAT_VERSION = "v2";

    public JsonBatchGenerator(EventProducer<Fact> commonsProducer, MetricEvent metricEvent, JsonFactory jsonFactory, BatcherSettings batcherSettings, long collectionInterval) {
        this.commonsProducer = commonsProducer;
        this.time = metricEvent.getTime() - metricEvent.getTime() % collectionInterval;
        this.type = metricEvent.getType();
        this.commons = metricEvent.getCommons();
        this.jsonFactory = jsonFactory;
        this.batcherSettings = batcherSettings;
    }

    public boolean startBatch() throws IOException {
        Collection<Event<Fact>> processed = this.commonsProducer.produce();
        if (processed.isEmpty()) {
            return false;
        }
        Fact fact = processed.iterator().next().getValue();
        HashMap<String, String> combinedCommons = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fact.getDimensionMap().entrySet()) {
            String dimension = entry.getKey();
            String dimensionValue = entry.getValue();
            combinedCommons.put(dimension, dimensionValue);
        }
        combinedCommons.putAll((Map<String, String>)this.commons);
        this.out = new ByteArrayOutputStream();
        this.jsonGenerator = this.jsonFactory.createGenerator(this.out, JsonEncoding.UTF8);
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeStringField(FORMAT_FIELD, METRIC_FORMAT_VERSION);
        this.jsonGenerator.writeNumberField(TIME_FIELD, this.time);
        this.jsonGenerator.writeStringField(TYPE_FIELD, this.type);
        this.jsonGenerator.writeFieldName(COMMONS_FIELD);
        this.jsonGenerator.writeStartObject();
        for (Map.Entry<String, String> entry : combinedCommons.entrySet()) {
            this.jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
        }
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeFieldName(EVENTS_FIELD);
        this.jsonGenerator.writeStartArray();
        this.numEvents = 0;
        return true;
    }

    public void startNextBatch() throws IOException {
        ++this.currentBatchId;
        this.startBatch();
    }

    public boolean isBatchLimitReached() {
        Preconditions.checkNotNull((Object)this.out, (Object)"Output stream is not available");
        return this.numEvents >= 100 || this.out.size() > 15000;
    }

    public boolean isBatchStarted() {
        return this.out != null;
    }

    public String generateJson() throws IOException {
        Preconditions.checkNotNull((Object)this.out, (Object)"Output stream is not available");
        Preconditions.checkNotNull((Object)this.jsonGenerator, (Object)"JSON generator is not available");
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeFieldName(METADATA_FIELD);
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeNumberField(BATCH_ID_FIELD, this.currentBatchId);
        this.jsonGenerator.writeBooleanField(AGGREGATED_FIELD, this.aggregated);
        this.jsonGenerator.writeBooleanField(LIMITED_FIELD, this.limited);
        this.jsonGenerator.writeStringField(PRODUCER_NAME_FIELD, this.getClass().getPackage().getImplementationTitle());
        this.jsonGenerator.writeStringField(PRODUCER_VERSION_FIELD, this.getClass().getPackage().getImplementationVersion());
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.close();
        String jsonOutput = new String(this.out.toByteArray(), StandardCharsets.UTF_8);
        this.jsonGenerator = null;
        this.out = null;
        this.aggregated = false;
        this.limited = false;
        return jsonOutput;
    }

    public void putEvent(MetricEvent metricEvent) throws IOException {
        Preconditions.checkNotNull((Object)this.jsonGenerator, (Object)"JSON generator is not available");
        this.aggregated |= metricEvent.isAggregated();
        this.limited |= metricEvent.isLimited();
        if (this.batcherSettings.isNested()) {
            ImmutableMap<String, String> customDimensions;
            this.jsonGenerator.writeStartObject();
            String customMetricName = metricEvent.getCustomMetricName();
            if (customMetricName != null) {
                this.jsonGenerator.writeStringField("metric_name", metricEvent.getCustomMetricName());
            }
            if (!(customDimensions = metricEvent.getCustomDimensions()).isEmpty()) {
                this.jsonGenerator.writeFieldName(DIMENSIONS_FIELD);
                this.jsonGenerator.writeStartObject();
                for (Map.Entry entry : metricEvent.getCustomDimensions().entrySet()) {
                    this.jsonGenerator.writeStringField((String)entry.getKey(), (String)entry.getValue());
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeFieldName(FACTS_FIELD);
            this.jsonGenerator.writeStartObject();
            this.writeFactFields(metricEvent);
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
        } else {
            this.jsonGenerator.writeStartObject();
            this.writeFactFields(metricEvent);
            this.jsonGenerator.writeEndObject();
        }
        ++this.numEvents;
    }

    private void writeFactFields(MetricEvent metricEvent) throws IOException {
        Preconditions.checkNotNull((Object)this.jsonGenerator, (Object)"JSON generator is not available");
        for (Map.Entry entry : metricEvent.getFacts().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Long) {
                this.jsonGenerator.writeNumberField(key, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                this.jsonGenerator.writeNumberField(key, (Double)value);
                continue;
            }
            this.jsonGenerator.writeStringField(key, String.valueOf(value));
        }
    }
}

