/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.mulesoft.agent.domain.monitoring.ApplicationMetrics;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.agent.Base64InfluxSafeEncoder;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.util.Maps;
import com.mulesoft.analytics.collector.util.Tuple;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.analytics.appstats")
@Singleton
public class AppStatsHandler
extends AbstractMessageHandler
implements InternalMessageHandler<GroupedApplicationsMetrics> {
    private static final Logger LOGGER = LogManager.getLogger(AppStatsHandler.class);
    @Inject
    private Base64InfluxSafeEncoder base64Encoder;
    @GuardedBy(value="vizPropsLock")
    final Map<String, Map<String, String>> vizProps = new HashMap<String, Map<String, String>>();
    private final Object vizPropsLock = new Object();
    Map<String, String> apiIdsMap = new ConcurrentHashMap<String, String>();
    @Nullable
    private String muleVersion = null;

    public boolean handle(GroupedApplicationsMetrics message) {
        if (!this.isEnabled() || message == null || this.muleVersion == null) {
            return false;
        }
        for (ApplicationMetrics am : message.getMetricsByApplicationName().values()) {
            String deploymentHash;
            String publicIP;
            String appName = this.configuration.overrideAppId(am.getApplicationName());
            if (appName == null) continue;
            List<Tuple<String, String>> tags = this.createBaseTags();
            tags.add(Tuple.tuple("app_id", appName));
            DeploymentType deploymentType = this.configuration.getDeploymentType();
            if (deploymentType != null) {
                tags.add(Tuple.tuple("deployment_type", deploymentType.name()));
            }
            if ((publicIP = this.configuration.getPublicIP()) != null) {
                tags.add(Tuple.tuple("public_ip", publicIP));
            }
            if ((deploymentHash = this.configuration.getDeploymentHash()) != null) {
                tags.add(Tuple.tuple("deployment_hash", deploymentHash));
            }
            for (Map.Entry<String, String> entry : Maps.emptyIfNull(this.getVizProps(appName)).entrySet()) {
                tags.add(Tuple.tuple(entry.getKey(), entry.getValue()));
            }
            String apiIds = this.apiIdsMap.get(appName);
            if (apiIds != null) {
                tags.add(Tuple.tuple("api_ids", apiIds));
            }
            tags.add(Tuple.tuple("mule_ver", this.muleVersion));
            tags.add(Tuple.tuple("ua_ver", this.configuration.getCollectorVersion()));
            Long timestamp = null;
            ArrayList<Tuple<String, String>> values = new ArrayList<Tuple<String, String>>();
            for (Metric metric : am.getMetrics()) {
                String name = metric.getName();
                Number value = metric.getValue();
                values.add(Tuple.tuple(name, value.toString()));
                if (timestamp != null) continue;
                timestamp = metric.getTimestamp();
            }
            if (timestamp == null) continue;
            MetricRecord record = MetricRecord.create("app_stats", tags, values, timestamp);
            this.output.write(record.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterApp(String appName) {
        appName = this.configuration.overrideAppId(appName);
        Object object = this.vizPropsLock;
        synchronized (object) {
            this.vizProps.remove(appName);
        }
        this.apiIdsMap.remove(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getVizProps(String appName) {
        if (!this.configuration.isAppDeployed(appName)) {
            return Collections.emptyMap();
        }
        Object object = this.vizPropsLock;
        synchronized (object) {
            Map<String, String> result = this.vizProps.get(appName);
            if (result != null) {
                return result;
            }
            Map<String, String> rawProperties = this.configuration.getVisualizerProperties(appName);
            Map<String, String> base64EncodedProperties = this.encodeNonBase64ConfVizProperties(rawProperties);
            result = new HashMap<String, String>();
            result.putAll(rawProperties);
            result.putAll(base64EncodedProperties);
            this.vizProps.put(appName, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Map<String, String>> getCachedVizProps() {
        Object object = this.vizPropsLock;
        synchronized (object) {
            return this.vizProps;
        }
    }

    Map<String, String> encodeNonBase64ConfVizProperties(Map<String, String> vizProperties) {
        HashMap<String, String> encodedNonBase64ConfProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> propNameAndValue : vizProperties.entrySet()) {
            try {
                String encodedValue = this.base64Encoder.encode(propNameAndValue.getValue(), StandardCharsets.UTF_8);
                Maps.putNonNull(encodedNonBase64ConfProperties, "base64." + propNameAndValue.getKey(), encodedValue);
            }
            catch (AssertionError | Exception e) {
                LOGGER.warn("Unable to make Base64 encoding for property '{}'. A normalized value will be used instead.", (Object)propNameAndValue.getKey());
            }
        }
        return encodedNonBase64ConfProperties;
    }

    public void addApiIds(@Nullable String appName, Collection<String> apiIds) {
        if (appName != null && apiIds.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String id : apiIds) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(id);
            }
            this.apiIdsMap.put(this.configuration.overrideAppId(appName), sb.toString());
        }
    }

    public void setMuleVersion(@Nullable String version) {
        this.muleVersion = version;
    }
}

