/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.CaseFormat;
import com.mulesoft.analytics.collector.agent.AbstractListener;
import com.mulesoft.analytics.collector.config.Configuration;
import com.mulesoft.analytics.collector.metrics.InvocationContext;
import com.mulesoft.analytics.collector.metrics.NodeType;
import com.mulesoft.analytics.collector.metrics.PipelineRegistry;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.EventPipeline;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.util.AttributeEvaluator;

public class ProcessorNotificationListener
extends AbstractListener
implements MessageProcessorNotificationListener<MessageProcessorNotification> {
    private static final Logger LOGGER = LogManager.getLogger(ProcessorNotificationListener.class);
    @Nullable
    private final String workerHash;
    private final EventPipeline<NotificationEnvelope> metricPipeline;

    public ProcessorNotificationListener(Configuration configuration, MuleContext muleContext, PipelineRegistry pipelineRegistry, String appId) {
        super(configuration, muleContext);
        this.workerHash = configuration.generateWorkerHash(appId);
        this.metricPipeline = pipelineRegistry.createOutboundPipeline(appId, new NotificationTransformer());
    }

    public void onNotification(MessageProcessorNotification notification) {
        String invocationId;
        LOGGER.debug("MessageProcessorNotification: {}", (Object)notification);
        if (notification.getSource() == null || notification.getSource().getMessage() == null) {
            LOGGER.debug("No mule message from notification");
            return;
        }
        if (notification.getProcessor() instanceof DefaultHttpRequester) {
            if (notification.getAction() == 1601) {
                ProcessorNotificationListener.incrementOutboundInvocationCounter();
                if (this.configuration.isHeaderInjectionEnabled()) {
                    MuleMessage message = notification.getSource().getMessage();
                    message.setProperty("x-anypnt-app-worker", (Object)this.workerHash, PropertyScope.OUTBOUND);
                }
            }
            invocationId = ProcessorNotificationListener.generateOutboundInvocationId(notification.getSource().getMessage().getUniqueId());
        } else {
            invocationId = notification.getSource().getMessage().getMessageRootId() + notification.getProcessorPath();
        }
        NotificationEnvelope envelope = new NotificationEnvelope(notification, invocationId);
        this.metricPipeline.submit(new Event<NotificationEnvelope>(envelope));
    }

    boolean resolveNodeType(MessageProcessorNotification notification, InvocationContext context) {
        String scheme;
        EndpointURI uri;
        MessageProcessor messageProcessor = notification.getProcessor();
        if (messageProcessor == null) {
            return false;
        }
        if (messageProcessor instanceof DefaultHttpRequester) {
            context.setConnector(NodeType.HTTP.getProcessorName());
            return true;
        }
        if (messageProcessor instanceof DefaultOutboundEndpoint && (uri = ((DefaultOutboundEndpoint)messageProcessor).getEndpointURI()) != null && (scheme = uri.getScheme()) != null) {
            context.setConnector(NodeType.OTHER.getProcessorName());
            context.setRemoteHost(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, scheme));
            return true;
        }
        return this.resolveType(context, messageProcessor, true);
    }

    private void resolveBasePath(InvocationContext context, MessageProcessorNotification notification) {
        MessageProcessor processor = notification.getProcessor();
        if (processor instanceof DefaultHttpRequester) {
            try {
                Object obj = FieldUtils.readField((Object)processor, (String)"basePath", (boolean)true);
                if (obj instanceof AttributeEvaluator) {
                    AttributeEvaluator eval = (AttributeEvaluator)obj;
                    String basePath = eval.getRawValue();
                    context.setBasePath(basePath);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to resolve basePath in {}", (Object)notification);
            }
        }
    }

    private class NotificationTransformer
    implements EventMapper<NotificationEnvelope, InvocationContext> {
        private NotificationTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Event<InvocationContext>> process(Event<NotificationEnvelope> event) {
            MessageProcessorNotification notification = event.getValue().notification;
            try {
                Collection<Event<Object>> collection;
                InvocationContext context = new InvocationContext();
                if (notification.getAction() == 1601) {
                    context.setAction(InvocationContext.Action.PRE_INVOKE);
                    ProcessorNotificationListener.this.resolveBasePath(context, notification);
                } else if (notification.getAction() == 1602 || notification.getAction() == 1603) {
                    String name = ServerNotification.getActionName((int)notification.getAction());
                    if (!"message processor post invoke".equals(name)) {
                        LOGGER.debug("Unsupported action name: {}", (Object)name);
                        List<Event<InvocationContext>> list = Collections.emptyList();
                        return list;
                    }
                    context.setAction(notification.getExceptionThrown() == null ? InvocationContext.Action.POST_INVOKE_SUCCESS : InvocationContext.Action.POST_INVOKE_ERROR);
                } else {
                    LOGGER.debug("Unsupported action: {}", (Object)notification.getAction());
                    List<Event<InvocationContext>> list = Collections.emptyList();
                    return list;
                }
                if (!ProcessorNotificationListener.this.resolveNodeType(notification, context)) {
                    LOGGER.debug("Message processor not handled: {}", (Object)notification.getProcessor());
                    collection = Collections.emptyList();
                    return collection;
                }
                context.setInvocationId(event.getValue().invocationId);
                context.setFlowName(notification.getResourceIdentifier());
                context.setSourceHash(ProcessorNotificationListener.this.workerHash);
                LOGGER.debug("Outbound invocation: {}", (Object)context);
                collection = Collections.singleton(new Event<long>(notification.getTimestamp(), context));
                return collection;
            }
            finally {
                AbstractListener.resetAccess(notification.getSource().getMessage());
            }
        }
    }

    private static class NotificationEnvelope {
        MessageProcessorNotification notification;
        String invocationId;

        NotificationEnvelope(MessageProcessorNotification notification, String invocationId) {
            this.notification = notification;
            this.invocationId = invocationId;
        }
    }
}

