/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.base.Strings;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HeuristicEndpointNormalizer
implements EventMapper<Fact, Fact> {
    public static final String REPLACEMENT = "X";
    private final String pathTagName;
    private final Set<String> preservedTokens;

    public HeuristicEndpointNormalizer(String pathTagName, Set<String> preservedTokens) {
        this.pathTagName = pathTagName;
        this.preservedTokens = preservedTokens;
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        String path = fact.getDimension(this.pathTagName);
        if (path != null) {
            String base = fact.getAttribute(Fact.Attribute.BASE_PATH);
            if (!Strings.isNullOrEmpty((String)base) && !base.equals("/") && path.startsWith(base)) {
                path = path.substring(base.length());
                path = this.normalize(path, 0);
                path = base + path;
            } else {
                path = this.normalize(path, 1);
            }
            fact.setDimension(this.pathTagName, path);
        }
        return Collections.singleton(event);
    }

    String normalize(String path, int startPartIndex) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        StringBuilder part = new StringBuilder();
        boolean allAlphas = true;
        boolean allUpperCase = true;
        int currPartIndex = 0;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if ('/' == c) {
                if (part.length() > 0) {
                    this.appendPart(result, part.toString(), allAlphas, allUpperCase, currPartIndex, startPartIndex);
                    part.setLength(0);
                    allAlphas = true;
                    allUpperCase = true;
                    ++currPartIndex;
                }
                result.append(c);
                continue;
            }
            part.append(c);
            if (!Character.isLetter(c) && c != '-' && c != '_') {
                allAlphas = false;
            }
            if (Character.isUpperCase(c)) continue;
            allUpperCase = false;
        }
        if (part.length() > 0) {
            this.appendPart(result, part.toString(), allAlphas, allUpperCase, currPartIndex, startPartIndex);
        }
        return result.toString();
    }

    private void appendPart(StringBuilder result, String part, boolean allAlphas, boolean allUpperCase, int curPartIndex, int startPartIndex) {
        boolean replace = false;
        if (!this.preservedTokens.contains(part)) {
            if (curPartIndex < startPartIndex) {
                if (!allAlphas) {
                    replace = true;
                }
            } else if (!allAlphas || allUpperCase) {
                replace = true;
            }
        }
        if (replace) {
            result.append(REPLACEMENT);
        } else {
            result.append(part);
        }
    }
}

