/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.metrics;

import com.google.common.base.Supplier;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.EventMapper;
import com.mulesoft.analytics.collector.pipeline.Fact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.glassfish.jersey.uri.UriTemplate;

public class RamlBasedEndpointNormalizer
implements EventMapper<Fact, Fact> {
    private List<Pair<UriTemplate, String>> templateEndpointPairs = new ArrayList<Pair<UriTemplate, String>>();
    private EventMapper<Fact, Fact> fallbackNormalizer;

    public RamlBasedEndpointNormalizer(Supplier<List<String>> templateSupplier, EventMapper<Fact, Fact> fallbackNormalizer) {
        this.fallbackNormalizer = fallbackNormalizer;
        for (String template : (List)templateSupplier.get()) {
            this.templateEndpointPairs.add((Pair<UriTemplate, String>)new ImmutablePair((Object)new UriTemplate(template), (Object)this.convertTemplateToEndpoint(template)));
        }
    }

    private String convertTemplateToEndpoint(String template) {
        return template.replaceAll("\\{.*?\\}", "X");
    }

    @Override
    public Collection<Event<Fact>> process(Event<Fact> event) {
        Fact fact = event.getValue();
        String basePath = fact.getAttribute(Fact.Attribute.BASE_PATH);
        if (basePath == null) {
            return this.fallbackNormalizer.process(event);
        }
        String endpoint = fact.getDimension("endpoint");
        if (endpoint != null) {
            String template = this.match(endpoint, basePath);
            if (template != null) {
                fact.setDimension("endpoint", template);
            } else {
                return this.fallbackNormalizer.process(event);
            }
        }
        return Collections.singleton(event);
    }

    @Nullable
    String match(String endpoint, String basePath) {
        if (endpoint.startsWith(basePath)) {
            endpoint = endpoint.substring(basePath.length());
            ArrayList notUsed = new ArrayList();
            for (Pair<UriTemplate, String> entry : this.templateEndpointPairs) {
                if (!((UriTemplate)entry.getKey()).match((CharSequence)endpoint, notUsed)) continue;
                return basePath + (String)entry.getValue();
            }
        }
        return null;
    }
}

