/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.collector.agent;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.analytics.collector.agent.AbstractMessageHandler;
import com.mulesoft.analytics.collector.agent.JMXMetricParser;
import com.mulesoft.analytics.collector.agent.JMXOperatingSystemMetricProvider;
import com.mulesoft.analytics.collector.config.DeploymentType;
import com.mulesoft.analytics.collector.log.MetricRecord;
import com.mulesoft.analytics.collector.log.MetricV2LogWriter;
import com.mulesoft.analytics.collector.metrics.EnvironmentProvider;
import com.mulesoft.analytics.collector.metrics.JsonFactLogger;
import com.mulesoft.analytics.collector.metrics.Metrics;
import com.mulesoft.analytics.collector.pipeline.Event;
import com.mulesoft.analytics.collector.pipeline.Fact;
import com.mulesoft.analytics.collector.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.dias.jvm")
@Singleton
public class JMXMetricHandler
extends AbstractMessageHandler
implements InternalMessageHandler<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(JMXMetricHandler.class);
    private static final String OPERATING_SYSTEM_METRIC_NAME = "operatingsystem";
    private static final ImmutableMap<String, String> JVM_TO_OS_METRIC_CONVERSION_MAP = ImmutableMap.builder().put((Object)"available_processors", (Object)"available_processors").put((Object)"load_average", (Object)"system_load_average").put((Object)"cpu", (Object)"process_cpu_load").put((Object)"total_physical_memory_size", (Object)"total_physical_memory_size").build();
    @Inject
    private JMXMetricParser jmxParser;
    @Inject
    private MetricV2LogWriter v2LogWriter;
    @Inject
    private JMXOperatingSystemMetricProvider metricProvider;
    private final Supplier<ScheduledExecutorService> scheduledExecSupplier = Suppliers.memoize((Supplier)new Supplier<ScheduledExecutorService>(){

        public ScheduledExecutorService get() {
            return Executors.newScheduledThreadPool(JMXMetricHandler.this.configuration.getThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("Pipeline-Scheduled-%d").build());
        }
    });
    private final Supplier<JsonFactLogger> jsonFactLoggerSupplier = Suppliers.memoize((Supplier)new Supplier<JsonFactLogger>(){

        public JsonFactLogger get() {
            return new JsonFactLogger(Metrics.SYSTEM_METRIC, new EnvironmentProvider(JMXMetricHandler.this.configuration, JMXMetricHandler.this.configuration.overrideAppId(null)), (ScheduledExecutorService)JMXMetricHandler.this.scheduledExecSupplier.get(), JMXMetricHandler.this.configuration.getAggregationTimeInterval(), JMXMetricHandler.this.configuration.getDeploymentType() == DeploymentType.RTF ? JMXMetricHandler.this.output : JMXMetricHandler.this.v2LogWriter, Metrics.BATCHER_SETTINGS_MAP);
        }
    });

    public boolean handle(ArrayList<Metric> message) {
        if (!this.isEnabled() || message == null) {
            return false;
        }
        List<Tuple<String, String>> tags = this.createSystemMetricTags();
        for (Metric metric : message) {
            this.parseAndWrite(metric, tags);
        }
        for (MetricRecord record : this.metricProvider.getMetrics(tags)) {
            ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(record, OPERATING_SYSTEM_METRIC_NAME)));
        }
        return true;
    }

    private void parseAndWrite(Metric metric, List<Tuple<String, String>> tags) {
        Number value = metric.getValue();
        String name = metric.getName();
        try {
            MetricRecord record = this.jmxParser.parse(name, value, tags);
            if (null != record) {
                List<MetricRecord> osRecords = this.generateOsMetric(record);
                for (MetricRecord osRecord : osRecords) {
                    ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(osRecord, osRecord.getName())));
                }
                ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).consume(new Event<Fact>(Fact.convert(record, record.getName())));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Unable to parse metric string '%s'", name), (Throwable)e);
        }
    }

    private List<MetricRecord> generateOsMetric(MetricRecord record) {
        List<Tuple<String, String>> tags = record.getTags();
        List<Tuple<String, String>> values = record.getValues();
        ArrayList<MetricRecord> result = new ArrayList<MetricRecord>();
        for (Tuple<String, String> pair : values) {
            String key = (String)JVM_TO_OS_METRIC_CONVERSION_MAP.get((Object)pair.first());
            if (key == null) continue;
            result.add(MetricRecord.create(OPERATING_SYSTEM_METRIC_NAME, tags, Collections.singletonList(Tuple.tuple(key, pair.second()))));
        }
        return result;
    }

    private List<Tuple<String, String>> createSystemMetricTags() {
        EnvironmentProvider commonTagProducer = new EnvironmentProvider(this.configuration, this.configuration.overrideAppId(null));
        ArrayList<Event<Fact>> events = new ArrayList<Event<Fact>>(commonTagProducer.produce());
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
        for (Map.Entry<String, String> e : ((Fact)((Event)events.get(0)).getValue()).getDimensionMap().entrySet()) {
            result.add(Tuple.tuple(e.getKey(), e.getValue()));
        }
        return result;
    }

    void writeJsonBatcher() {
        ((JsonFactLogger)this.jsonFactLoggerSupplier.get()).writeBatcher();
    }
}

