/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.AdaptiveConfig;
import com.mulesoft.analytics.limiter.PropertiesUtil;
import java.util.Properties;

public class AdaptiveConfigImpl
implements AdaptiveConfig {
    @Deprecated
    public static final String LIMITER_STRATEGY_SAMPLING_SIZE = "limiter.strategy.sampling-size";
    @Deprecated
    public static final String LIMITER_STRATEGY_DISTRIBUTION_BOUND = "limiter.output.distribution-bound";
    private double singleEventLowerBound = 0.01;
    private double singleEventUpperBound = 0.15;
    private double combinedEventLowerBound = 0.8;
    private int perDimMaximumN = 5;

    public AdaptiveConfigImpl(double singleEventLowerBound, double singleEventUpperBound, double combinedEventLowerBound, int maximumN) {
        this.singleEventLowerBound = singleEventLowerBound;
        this.singleEventUpperBound = singleEventUpperBound;
        this.combinedEventLowerBound = combinedEventLowerBound;
        this.perDimMaximumN = maximumN;
    }

    public AdaptiveConfigImpl() {
    }

    public AdaptiveConfigImpl(AdaptiveConfig other) {
        this(other.getSingleEventLowerBound(), other.getSingleEventUpperBound(), other.getCombinedEventLowerBound(), other.getPerDimMaximumN());
    }

    public void fromConfiguration(Properties config, String prefix) {
        int samplingSize = PropertiesUtil.getInt(config, LIMITER_STRATEGY_SAMPLING_SIZE, this.getPerDimMaximumN());
        this.setPerDimMaximumN(PropertiesUtil.getInt(config, prefix + "maximum-n-per-dimension", samplingSize));
        double distributionBound = PropertiesUtil.getDouble(config, LIMITER_STRATEGY_DISTRIBUTION_BOUND, this.getCombinedEventLowerBound());
        this.setCombinedEventLowerBound(PropertiesUtil.getDouble(config, prefix + "combined-event-lower-bound", distributionBound));
        this.setSingleEventLowerBound(PropertiesUtil.getDouble(config, prefix + "single-event-lower-bound", this.getSingleEventLowerBound()));
        this.setSingleEventUpperBound(PropertiesUtil.getDouble(config, prefix + "single-event-upper-bound", this.getSingleEventUpperBound()));
    }

    public void toConfiguration(Properties config, String prefix) {
        config.setProperty(prefix + "maximum-n-per-dimension", Integer.toString(this.getPerDimMaximumN()));
        config.setProperty(prefix + "combined-event-lower-bound", Double.toString(this.getCombinedEventLowerBound()));
        config.setProperty(prefix + "single-event-lower-bound", Double.toString(this.getSingleEventLowerBound()));
        config.setProperty(prefix + "single-event-upper-bound", Double.toString(this.getSingleEventUpperBound()));
    }

    @Override
    public double getSingleEventLowerBound() {
        return this.singleEventLowerBound;
    }

    @Override
    public double getSingleEventUpperBound() {
        return this.singleEventUpperBound;
    }

    @Override
    public double getCombinedEventLowerBound() {
        return this.combinedEventLowerBound;
    }

    @Override
    public int getPerDimMaximumN() {
        return this.perDimMaximumN;
    }

    public void setSingleEventLowerBound(double singleEventLowerBound) {
        if (singleEventLowerBound < 0.0 || singleEventLowerBound > 1.0) {
            throw new IllegalArgumentException("single lower bound must be a ration betwen 0.0 and 1.0");
        }
        this.singleEventLowerBound = singleEventLowerBound;
    }

    public void setSingleEventUpperBound(double singleEventUpperBound) {
        if (singleEventUpperBound < 0.0 || singleEventUpperBound > 1.0) {
            throw new IllegalArgumentException("single upper bound must be a ration betwen 0.0 and 1.0");
        }
        this.singleEventUpperBound = singleEventUpperBound;
    }

    public void setCombinedEventLowerBound(double combinedEventLowerBound) {
        if (combinedEventLowerBound < 0.0 || combinedEventLowerBound > 1.0) {
            throw new IllegalArgumentException("combined upper bound must be a ration betwen 0.0 and 1.0");
        }
        this.combinedEventLowerBound = combinedEventLowerBound;
    }

    public void setPerDimMaximumN(int maximumN) {
        if (maximumN < 0) {
            throw new IllegalArgumentException("maximum N cannot be less than 0");
        }
        this.perDimMaximumN = maximumN;
    }
}

