/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.analytics.limiter;

import com.mulesoft.analytics.limiter.AdaptiveConfigBuilder;
import com.mulesoft.analytics.limiter.AdaptiveConfigImpl;
import com.mulesoft.analytics.limiter.EventProcessor;
import com.mulesoft.analytics.limiter.EventProcessorConfigImpl;
import com.mulesoft.analytics.limiter.NamePath;
import com.mulesoft.analytics.limiter.StrategyType;
import com.mulesoft.analytics.limiter.data.StringNamePath;
import com.mulesoft.analytics.limiter.processor.EventProcessorImpl;
import com.mulesoft.analytics.limiter.processor.ImmutableEventProcessorConfig;
import com.mulesoft.analytics.limiter.processor.ImmutableEventProcessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DefaultEventProcessorBuilder {
    private final EventProcessorConfigImpl config;
    private final AdaptiveConfigBuilder adaptiveConfigBuilder = new AdaptiveConfigBuilder();
    private final HashSet<NamePath> retainingDims;
    private final HashSet<NamePath> collapsibleDims;
    private final HashSet<NamePath> longMetricDims;
    private final HashSet<NamePath> doubleMetricDims;
    private final HashMap<NamePath, AdaptiveConfigBuilder> perDimAdaptiveBuilder = new HashMap();

    public DefaultEventProcessorBuilder() {
        this.config = new EventProcessorConfigImpl();
        this.retainingDims = new HashSet();
        this.collapsibleDims = new HashSet();
        this.longMetricDims = new HashSet();
        this.doubleMetricDims = new HashSet();
    }

    public DefaultEventProcessorBuilder setProperties(Properties properties) {
        this.config.setProperties(properties);
        return this;
    }

    public DefaultEventProcessorBuilder setProperties(String properties) {
        StringReader reader = new StringReader(properties);
        try {
            this.setProperties(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("String given does not contain valid properties.");
        }
        return this;
    }

    public DefaultEventProcessorBuilder setProperties(Reader properties) throws IOException {
        Properties props = new Properties();
        props.load(properties);
        return this.setProperties(props);
    }

    public DefaultEventProcessorBuilder setProperties(InputStream properties) throws IOException {
        Properties props = new Properties();
        props.load(properties);
        return this.setProperties(props);
    }

    public DefaultEventProcessorBuilder addCollapsibleDimension(NamePath ... namePaths) {
        if (namePaths != null) {
            for (NamePath namePath : namePaths) {
                this.collapsibleDims.add(namePath);
            }
        }
        return this;
    }

    public DefaultEventProcessorBuilder addCollapsibleDimension(String ... namePaths) {
        return this.addCollapsibleDimension(this.convertToNamePaths(namePaths));
    }

    public DefaultEventProcessorBuilder addRetainingDimension(NamePath ... namePaths) {
        if (namePaths != null) {
            for (NamePath namePath : namePaths) {
                this.retainingDims.add(namePath);
            }
        }
        return this;
    }

    public DefaultEventProcessorBuilder addRetainingDimension(String ... namePaths) {
        return this.addRetainingDimension(this.convertToNamePaths(namePaths));
    }

    public DefaultEventProcessorBuilder addLongMetric(NamePath ... namePaths) {
        if (namePaths != null) {
            for (NamePath namePath : namePaths) {
                this.longMetricDims.add(namePath);
            }
        }
        return this;
    }

    public DefaultEventProcessorBuilder addLongMetric(String ... namePaths) {
        return this.addLongMetric(this.convertToNamePaths(namePaths));
    }

    public DefaultEventProcessorBuilder addDoubleMetric(NamePath ... namePaths) {
        if (namePaths != null) {
            for (NamePath namePath : namePaths) {
                this.doubleMetricDims.add(namePath);
            }
        }
        return this;
    }

    public DefaultEventProcessorBuilder addDoubleMetric(String ... namePaths) {
        return this.addDoubleMetric(this.convertToNamePaths(namePaths));
    }

    private NamePath[] convertToNamePaths(String ... namePaths) {
        if (namePaths == null) {
            return null;
        }
        NamePath[] args = new NamePath[namePaths.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = StringNamePath.fromString(namePaths[i]);
        }
        return args;
    }

    public DefaultEventProcessorBuilder setStrategy(StrategyType strategy) {
        this.config.setStrategy(strategy);
        return this;
    }

    public DefaultEventProcessorBuilder setMaxOutput(int maxOutput) {
        this.config.setMaxOutput(maxOutput);
        return this;
    }

    @Deprecated
    public DefaultEventProcessorBuilder setSamplingSize(int samplingSize) {
        this.adaptiveConfigBuilder.setPerDimMaximumN(samplingSize);
        return this;
    }

    public DefaultEventProcessorBuilder setContainerSize(int containerSize) {
        this.config.setContainerSize(containerSize);
        return this;
    }

    public AdaptiveConfigBuilder getAdaptiveConfigBuilder() {
        return this.adaptiveConfigBuilder;
    }

    public AdaptiveConfigBuilder getAdaptiveConfigBuilder(NamePath dimension) {
        AdaptiveConfigBuilder result = this.perDimAdaptiveBuilder.get(dimension);
        if (result == null) {
            result = new AdaptiveConfigBuilder();
            this.perDimAdaptiveBuilder.put(dimension, result);
        }
        return result;
    }

    public AdaptiveConfigBuilder getAdaptiveConfigBuilder(String namePath) {
        return this.getAdaptiveConfigBuilder(StringNamePath.fromString(namePath));
    }

    @Deprecated
    public DefaultEventProcessorBuilder setDistributionBound(double distributionBound) {
        this.getAdaptiveConfigBuilder().setCombinedEventLowerBound(distributionBound);
        return this;
    }

    public DefaultEventProcessorBuilder setCollaspeableDimensions(Set<NamePath> collaspeableDimensions) {
        this.config.setCollapsibleDimensions(collaspeableDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setRetainingDimensions(Set<NamePath> retainingDimensions) {
        this.config.setRetainingDimensions(retainingDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setLongMetricDimensions(Set<NamePath> metricDimensions) {
        this.config.setLongMetricDimensions(metricDimensions);
        return this;
    }

    public DefaultEventProcessorBuilder setDoubleMetricDimensions(Set<NamePath> metricDimensions) {
        this.config.setDoubleMetricDimensions(metricDimensions);
        return this;
    }

    public EventProcessor build() {
        this.configure();
        return new EventProcessorImpl(this.config);
    }

    public EventProcessor.Factory buildFactory() {
        this.configure();
        ImmutableEventProcessorConfig immutableConfig = new ImmutableEventProcessorConfig(this.config.getMaxOutput(), this.config.getAdaptiveConfig().getPerDimMaximumN(), this.config.getContainerSize(), this.config.getAdaptiveConfig().getCombinedEventLowerBound(), this.config.getStrategy(), this.config.getRetainingDims(), this.config.getCollapsibleDims(), this.config.getLongMetricDims(), this.config.getDoubleMetricDims());
        return new ImmutableEventProcessorFactory(immutableConfig);
    }

    private void configure() {
        if (this.config.getMaxOutput() <= 0) {
            throw new IllegalArgumentException("Must set the output size to be > 0");
        }
        if (this.config.getStrategy() == null) {
            throw new IllegalArgumentException("Must specify a limiter strategy.");
        }
        if (this.config.getContainerSize() == 0 || this.config.getContainerSize() < this.config.getMaxOutput()) {
            throw new IllegalArgumentException("Container size (" + this.config.getContainerSize() + ") must be > output size (" + this.config.getMaxOutput() + ")");
        }
        if (this.config.getCollapsibleDimensions() != null && !this.config.getCollapsibleDimensions().isEmpty()) {
            for (NamePath p : this.config.getCollapsibleDimensions()) {
                this.collapsibleDims.add(p);
            }
        }
        if (this.config.getRetainingDimensions() != null && !this.config.getRetainingDimensions().isEmpty()) {
            for (NamePath p : this.config.getRetainingDimensions()) {
                this.retainingDims.add(p);
            }
        }
        if (this.config.getLongMetricDimensions() != null && !this.config.getLongMetricDimensions().isEmpty()) {
            for (NamePath p : this.config.getLongMetricDimensions()) {
                this.longMetricDims.add(p);
            }
        }
        if (this.config.getDoubleMetricDimensions() != null && !this.config.getDoubleMetricDimensions().isEmpty()) {
            for (NamePath p : this.config.getDoubleMetricDimensions()) {
                this.doubleMetricDims.add(p);
            }
        }
        this.config.setCollapsibleDimensions(this.collapsibleDims);
        this.config.setRetainingDimensions(this.retainingDims);
        this.config.setLongMetricDimensions(this.longMetricDims);
        this.config.setDoubleMetricDimensions(this.doubleMetricDims);
        this.adaptiveConfigBuilder.apply(this.config.getAdaptiveConfig());
        for (NamePath name : this.perDimAdaptiveBuilder.keySet()) {
            AdaptiveConfigImpl perDimAdaptiveConfig = this.config.getPerDimAdaptiveConfig().get(name);
            if (perDimAdaptiveConfig == null) {
                perDimAdaptiveConfig = new AdaptiveConfigImpl(this.config.getAdaptiveConfig());
            }
            if (!this.config.getCollapsibleDimensions().contains(name)) {
                throw new IllegalArgumentException("Cannot have an Adaptive Config for " + name + " because this dimension is defined not collapsible.");
            }
            this.config.getPerDimAdaptiveConfig().put(name, this.perDimAdaptiveBuilder.get(name).apply(perDimAdaptiveConfig));
        }
    }
}

